/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.map.MapProxy;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private final Type beanType;
    private final Class<T> beanClass;
    private final CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this.beanType = beanType;
        this.beanClass = TypeKit.getClass(beanType);
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanKit.isBean(value.getClass())) {
            if (value instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)value).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(value, ReflectKit.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return ObjectKit.deserialize((byte[])value);
        }
        return null;
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

