/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.mail;

import java.io.Serializable;
import java.util.Properties;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.mail.InternalMail;
import org.aoju.bus.setting.magic.PopSetting;

public class MailAccount
implements Serializable {
    public static final String MAIL_SETTING_PATH = "mail.setting";
    private static final long serialVersionUID = 1L;
    private static final String MAIL_PROTOCOL = "mail.transport.protocol";
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String SMTP_TIMEOUT = "mail.smtp.timeout";
    private static final String STARTTTLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String SOCKEY_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SOCKEY_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String SOCKEY_FACTORY_PORT = "smtp.socketFactory.port";
    private static final String MAIL_DEBUG = "mail.debug";
    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private String host;
    private Integer port;
    private Boolean auth;
    private String user;
    private String pass;
    private String from;
    private boolean debug;
    private java.nio.charset.Charset charset = Charset.UTF_8;
    private boolean splitlongparameters;
    private boolean startttlsEnable = false;
    private Boolean sslEnable;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback;
    private int socketFactoryPort = 465;
    private long timeout;
    private long connectionTimeout;

    public MailAccount() {
    }

    public MailAccount(String settingPath) {
        this(new PopSetting(settingPath));
    }

    public MailAccount(PopSetting setting) {
        setting.toBean(this);
    }

    public String getHost() {
        return this.host;
    }

    public MailAccount setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public MailAccount setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isAuth() {
        return this.auth;
    }

    public MailAccount setAuth(boolean isAuth) {
        this.auth = isAuth;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public MailAccount setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    public MailAccount setPass(String pass) {
        this.pass = pass;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public MailAccount setFrom(String from) {
        this.from = from;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public MailAccount setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public java.nio.charset.Charset getCharset() {
        return this.charset;
    }

    public MailAccount setCharset(java.nio.charset.Charset charset) {
        this.charset = charset;
        return this;
    }

    public boolean isSplitlongparameters() {
        return this.splitlongparameters;
    }

    public void setSplitlongparameters(boolean splitlongparameters) {
        this.splitlongparameters = splitlongparameters;
    }

    public boolean isStartttlsEnable() {
        return this.startttlsEnable;
    }

    public MailAccount setStartttlsEnable(boolean startttlsEnable) {
        this.startttlsEnable = startttlsEnable;
        return this;
    }

    public Boolean isSslEnable() {
        return this.sslEnable;
    }

    public MailAccount setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
        return this;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    public MailAccount setSocketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
        return this;
    }

    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public MailAccount setSocketFactoryFallback(boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
        return this;
    }

    public int getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    public MailAccount setSocketFactoryPort(int socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
        return this;
    }

    public MailAccount setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public MailAccount setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Properties getSmtpProps() {
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(this.splitlongparameters));
        Properties p = new Properties();
        p.put(MAIL_PROTOCOL, "smtp");
        p.put(SMTP_HOST, this.host);
        p.put(SMTP_PORT, String.valueOf(this.port));
        p.put(SMTP_AUTH, String.valueOf(this.auth));
        if (this.timeout > 0L) {
            p.put(SMTP_TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.connectionTimeout > 0L) {
            p.put(SMTP_CONNECTION_TIMEOUT, String.valueOf(this.connectionTimeout));
        }
        p.put(MAIL_DEBUG, String.valueOf(this.debug));
        if (this.startttlsEnable) {
            p.put(STARTTTLS_ENABLE, String.valueOf(this.startttlsEnable));
            if (null == this.sslEnable) {
                this.sslEnable = true;
            }
        }
        if (null != this.sslEnable && this.sslEnable.booleanValue()) {
            p.put(SOCKEY_FACTORY, this.socketFactoryClass);
            p.put(SOCKEY_FACTORY_FALLBACK, String.valueOf(this.socketFactoryFallback));
            p.put(SOCKEY_FACTORY_PORT, String.valueOf(this.socketFactoryPort));
        }
        return p;
    }

    public MailAccount defaultIfEmpty() {
        String fromAddress = InternalMail.parseFirstAddress(this.from, this.charset).getAddress();
        if (StringKit.isBlank(this.host)) {
            this.host = StringKit.format("smtp.{}", StringKit.subSuf(fromAddress, fromAddress.indexOf(64) + 1));
        }
        if (StringKit.isBlank(this.user)) {
            this.user = StringKit.subPre(fromAddress, fromAddress.indexOf(64));
        }
        if (null == this.auth) {
            this.auth = false == StringKit.isBlank(this.pass);
        }
        if (null == this.port) {
            this.port = null != this.sslEnable && this.sslEnable != false ? this.socketFactoryPort : 25;
        }
        if (null == this.charset) {
            this.charset = Charset.UTF_8;
        }
        return this;
    }
}

