/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.drivers;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.linux.ProcPath;

@ThreadSafe
public final class ProcessStat {
    public static final int PROC_PID_STAT_LENGTH;

    private ProcessStat() {
    }

    public static Triple<String, Character, Map<PidStat, Long>> getPidStats(int pid) {
        String stat = Builder.getStringFromFile(String.format(ProcPath.PID_STAT, pid));
        if (stat.isEmpty()) {
            return null;
        }
        int nameStart = stat.indexOf(40) + 1;
        int nameEnd = stat.indexOf(41);
        String name = stat.substring(nameStart, nameEnd);
        Character state = Character.valueOf(stat.charAt(nameEnd + 2));
        String[] split = RegEx.SPACES.split(stat.substring(nameEnd + 4).trim());
        EnumMap<PidStat, Long> statMap = new EnumMap<PidStat, Long>(PidStat.class);
        PidStat[] enumArray = (PidStat[])PidStat.class.getEnumConstants();
        for (int i = 3; i < enumArray.length && i - 3 < split.length; ++i) {
            statMap.put(enumArray[i], Builder.parseLongOrDefault(split[i - 3], 0L));
        }
        return Triple.of(name, state, statMap);
    }

    public static Map<PidStatM, Long> getPidStatM(int pid) {
        String statm = Builder.getStringFromFile(String.format(ProcPath.PID_STATM, pid));
        if (statm.isEmpty()) {
            return null;
        }
        String[] split = RegEx.SPACES.split(statm);
        EnumMap<PidStatM, Long> statmMap = new EnumMap<PidStatM, Long>(PidStatM.class);
        PidStatM[] enumArray = (PidStatM[])PidStatM.class.getEnumConstants();
        for (int i = 0; i < enumArray.length && i < split.length; ++i) {
            statmMap.put(enumArray[i], Builder.parseLongOrDefault(split[i], 0L));
        }
        return statmMap;
    }

    public static File[] getPidFiles() {
        File procdir = new File(ProcPath.PROC);
        File[] pids = procdir.listFiles(f -> RegEx.NUMBERS.matcher(f.getName()).matches());
        return pids != null ? pids : new File[]{};
    }

    public static List<Integer> getThreadIds(int pid) {
        File threadDir = new File(String.format(ProcPath.TASK_PATH, pid));
        File[] threads = threadDir.listFiles(file -> RegEx.NUMBERS.matcher(file.getName()).matches() && Integer.valueOf(file.getName()) != pid);
        return threads != null ? Arrays.stream(threads).map(thread -> Builder.parseIntOrDefault(thread.getName(), 0)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static OSProcess.State getState(char stateValue) {
        OSProcess.State state;
        switch (stateValue) {
            case 'R': {
                state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': {
                state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                state = OSProcess.State.OTHER;
            }
        }
        return state;
    }

    static {
        String stat = Builder.getStringFromFile(ProcPath.SELF_STAT);
        PROC_PID_STAT_LENGTH = !stat.isEmpty() && stat.contains(")") ? Builder.countStringToLongArray(stat, ' ') + 3 : 52;
    }

    public static enum PidStatM {
        SIZE,
        RESIDENT,
        SHARED,
        TEXT,
        LIB,
        DATA,
        DT;

    }

    public static enum PidStat {
        PID,
        COMM,
        STATE,
        PPID,
        PGRP,
        SESSION,
        TTY_NR,
        PTGID,
        FLAGS,
        MINFLT,
        CMINFLT,
        MAJFLT,
        CMAJFLT,
        UTIME,
        STIME,
        CUTIME,
        CSTIME,
        PRIORITY,
        NICE,
        NUM_THREADS,
        ITREALVALUE,
        STARTTIME,
        VSIZE,
        RSS,
        RSSLIM,
        STARTCODE,
        ENDCODE,
        STARTSTACK,
        KSTKESP,
        KSTKEIP,
        SIGNAL,
        BLOCKED,
        SIGIGNORE,
        SIGCATCH,
        WCHAN,
        NSWAP,
        CNSWAP,
        EXIT_SIGNAL,
        PROCESSOR,
        RT_PRIORITY,
        POLICY,
        DELAYACCT_BLKIO_TICKS,
        GUEST_TIME,
        CGUEST_TIME,
        START_DATA,
        END_DATA,
        START_BRK,
        ARG_START,
        ARG_END,
        ENV_START,
        ENV_END,
        EXIT_CODE;

    }
}

