/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.logger.Logger;

public class SpecificCharacterSet {
    public static final SpecificCharacterSet ASCII = new SpecificCharacterSet(new Codec[]{Codec.GB18030}, new String[0]);
    private static final ThreadLocal<SoftReference<Encoder>> cachedEncoder1 = new ThreadLocal();
    private static final ThreadLocal<SoftReference<Encoder>> cachedEncoder2 = new ThreadLocal();
    private static SpecificCharacterSet DEFAULT = ASCII;
    protected final Codec[] codecs;
    protected final String[] dicomCodes;

    protected SpecificCharacterSet(Codec[] codecs, String ... codes) {
        this.codecs = codecs;
        this.dicomCodes = codes;
    }

    public static SpecificCharacterSet getDefaultCharacterSet() {
        return DEFAULT;
    }

    public static void setDefaultCharacterSet(String code) {
        SpecificCharacterSet cs;
        SpecificCharacterSet specificCharacterSet = cs = code != null ? SpecificCharacterSet.valueOf(code) : ASCII;
        if (!cs.containsASCII()) {
            throw new IllegalArgumentException("Default Character Set must contain ASCII - " + code);
        }
        DEFAULT = cs;
    }

    public static SpecificCharacterSet valueOf(String ... codes) {
        if (codes == null || codes.length == 0) {
            return DEFAULT;
        }
        if (codes.length > 1) {
            codes = SpecificCharacterSet.checkISO2022(codes);
        }
        Codec[] infos = new Codec[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            infos[i] = Codec.forCode(codes[i]);
        }
        return codes.length > 1 ? new ISO2022(infos, codes) : new SpecificCharacterSet(infos, codes);
    }

    private static String[] checkISO2022(String[] codes) {
        for (String code : codes) {
            if (code == null || code.isEmpty() || code.startsWith("ISO 2022")) continue;
            Logger.info("Invalid Specific Character Set: [{}] - treat as [{}]", Property.concat(codes, '\\'), Property.maskNull(codes[0], ""));
            return new String[]{codes[0]};
        }
        return codes;
    }

    private static Encoder encoder(ThreadLocal<SoftReference<Encoder>> tl, Codec codec) {
        Encoder enc;
        SoftReference<Encoder> sr = tl.get();
        if (sr == null || (enc = sr.get()) == null || enc.codec != codec) {
            enc = new Encoder(codec);
            tl.set(new SoftReference<Encoder>(enc));
        }
        return enc;
    }

    public String[] toCodes() {
        return this.dicomCodes;
    }

    public byte[] encode(String val, String delimiters) {
        return this.codecs[0].encode(val);
    }

    public String decode(byte[] val) {
        return this.codecs[0].decode(val, 0, val.length);
    }

    public boolean isUTF8() {
        return this.codecs[0].equals((Object)Codec.UTF_8);
    }

    public boolean isASCII() {
        return this.codecs[0].equals((Object)Codec.ISO_646);
    }

    public boolean containsASCII() {
        return this.codecs[0].containsASCII();
    }

    public String toText(String s) {
        return this.codecs[0].toText(s);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SpecificCharacterSet othercs = (SpecificCharacterSet)other;
        return Arrays.equals((Object[])this.codecs, (Object[])othercs.codecs);
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.codecs);
    }

    private static final class ISO2022
    extends SpecificCharacterSet {
        private ISO2022(Codec[] charsetInfos, String ... codes) {
            super(charsetInfos, codes);
        }

        @Override
        public byte[] encode(String val, String delimiters) {
            byte[] buf;
            ByteBuffer bb;
            int strlen = val.length();
            CharBuffer cb = CharBuffer.wrap(val.toCharArray());
            Encoder enc1 = SpecificCharacterSet.encoder(cachedEncoder1, this.codecs[0]);
            if (!enc1.encode(cb, bb = ByteBuffer.wrap(buf = new byte[strlen]), 0, CodingErrorAction.REPORT)) {
                Encoder[] encs = new Encoder[this.codecs.length];
                encs[0] = enc1;
                encs[1] = SpecificCharacterSet.encoder(cachedEncoder2, this.codecs[1]);
                StringTokenizer comps = new StringTokenizer(val, delimiters, true);
                buf = new byte[2 * strlen + 4 * (comps.countTokens() + 1)];
                bb = ByteBuffer.wrap(buf);
                int[] cur = new int[]{0, 0};
                while (comps.hasMoreTokens()) {
                    String comp = comps.nextToken();
                    if (comp.length() == 1 && delimiters.indexOf(comp.charAt(0)) >= 0) {
                        this.activateInitialCharacterSet(bb, cur);
                        bb.put((byte)comp.charAt(0));
                        continue;
                    }
                    cb = CharBuffer.wrap(comp.toCharArray());
                    this.encodeComponent(encs, cb, bb, cur);
                }
                this.activateInitialCharacterSet(bb, cur);
            }
            return Arrays.copyOf(buf, bb.position());
        }

        private void encodeComponent(Encoder[] encs, CharBuffer cb, ByteBuffer bb, int[] cur) {
            if (this.codecs[cur[1]].getEscSeq1() != 0 && encs[cur[1]].encode(cb, bb, 0, CodingErrorAction.REPORT)) {
                return;
            }
            if ((this.codecs[cur[1]].getEscSeq1() == 0 || this.codecs[cur[1]].getEscSeq0() != this.codecs[cur[0]].getEscSeq0()) && encs[cur[0]].encode(cb, bb, 0, CodingErrorAction.REPORT)) {
                return;
            }
            int next = encs.length;
            while (--next >= 0) {
                if (encs[next] == null) {
                    encs[next] = new Encoder(this.codecs[next]);
                }
                if (this.codecs[next].getEscSeq1() != 0) {
                    if (!encs[next].encode(cb, bb, this.codecs[next].getEscSeq1(), CodingErrorAction.REPORT)) continue;
                    cur[1] = next;
                    break;
                }
                if (!encs[next].encode(cb, bb, this.codecs[next].getEscSeq0(), CodingErrorAction.REPORT)) continue;
                cur[0] = next;
                break;
            }
            if (next < 0) {
                if (cb.length() > 1) {
                    for (int i = 0; i < cb.length(); ++i) {
                        this.encodeComponent(encs, cb.subSequence(i, i + 1), bb, cur);
                    }
                } else {
                    bb.put(encs[cur[0]].replacement());
                }
            }
        }

        private void activateInitialCharacterSet(ByteBuffer bb, int[] cur) {
            if (cur[0] != 0) {
                Encoder.escSeq(bb, this.codecs[0].getEscSeq0());
                cur[0] = 0;
            }
            if (cur[1] != 0) {
                Encoder.escSeq(bb, this.codecs[0].getEscSeq1());
                cur[1] = 0;
            }
        }

        @Override
        public String decode(byte[] b) {
            Codec[] codec = new Codec[]{this.codecs[0], this.codecs[0]};
            int g = 0;
            int off = 0;
            int cur = 0;
            StringBuilder sb = new StringBuilder(b.length);
            while (cur < b.length) {
                int bytesPerChar;
                if (b[cur] == 27 && cur + 2 < b.length) {
                    if (off < cur) {
                        sb.append(codec[g].decode(b, off, cur - off));
                    }
                    int esc0 = cur++;
                    int esc1 = cur++;
                    int esc2 = cur++;
                    block0 : switch (((b[esc1] & 0xFF) << 8) + (b[esc2] & 0xFF)) {
                        case 9256: {
                            if (cur < b.length && b[cur++] == 68) {
                                codec[0] = Codec.JIS_X_212;
                                break;
                            }
                            sb.append(codec[0].decode(b, esc0, cur - esc0));
                            break;
                        }
                        case 9257: {
                            switch (cur < b.length ? b[cur++] : -1) {
                                case 65: {
                                    this.switchCodec(codec, 1, Codec.GB2312);
                                    break block0;
                                }
                                case 67: {
                                    this.switchCodec(codec, 1, Codec.KS_X_1001);
                                    break block0;
                                }
                            }
                            sb.append(codec[0].decode(b, esc0, cur - esc0));
                            break;
                        }
                        case 9282: {
                            codec[0] = Codec.JIS_X_208;
                            break;
                        }
                        case 10306: {
                            this.switchCodec(codec, 0, Codec.ISO_646);
                            break;
                        }
                        case 10314: {
                            codec[0] = Codec.JIS_X_201;
                            if (codec[1].getEscSeq1() != 0) break;
                            codec[1] = codec[0];
                            break;
                        }
                        case 10569: {
                            codec[1] = Codec.JIS_X_201;
                            break;
                        }
                        case 11585: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_1);
                            break;
                        }
                        case 11586: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_2);
                            break;
                        }
                        case 11587: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_3);
                            break;
                        }
                        case 11588: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_4);
                            break;
                        }
                        case 11590: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_7);
                            break;
                        }
                        case 11591: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_6);
                            break;
                        }
                        case 11592: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_8);
                            break;
                        }
                        case 11596: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_5);
                            break;
                        }
                        case 11597: {
                            this.switchCodec(codec, 1, Codec.ISO_8859_9);
                            break;
                        }
                        case 11604: {
                            this.switchCodec(codec, 1, Codec.TIS_620);
                            break;
                        }
                        default: {
                            sb.append(codec[0].decode(b, esc0, cur - esc0));
                        }
                    }
                    off = cur;
                    continue;
                }
                if (codec[0] != codec[1] && g == (b[cur] < 0 ? 0 : 1)) {
                    if (off < cur) {
                        sb.append(codec[g].decode(b, off, cur - off));
                    }
                    off = cur;
                    g = 1 - g;
                }
                cur += (bytesPerChar = codec[g].getBytesPerChar()) > 0 ? bytesPerChar : (b[cur] < 0 ? 2 : 1);
            }
            if (off < cur) {
                sb.append(codec[g].decode(b, off, Math.min(cur, b.length) - off));
            }
            return sb.toString();
        }

        private void switchCodec(Codec[] codecs, int i, Codec codec) {
            codecs[i] = codec;
            if (codecs[0].getEscSeq0() == codecs[1].getEscSeq0()) {
                codecs[0] = codecs[1];
            }
        }
    }

    private static final class Encoder {
        final Codec codec;
        final CharsetEncoder encoder;

        public Encoder(Codec codec) {
            this.codec = codec;
            this.encoder = Charset.forName(codec.charsetName).newEncoder();
        }

        private static void escSeq(ByteBuffer bb, int seq) {
            if (seq == 0) {
                return;
            }
            bb.put((byte)27);
            int b1 = seq >> 16;
            if (b1 != 0) {
                bb.put((byte)b1);
            }
            bb.put((byte)(seq >> 8));
            bb.put((byte)seq);
        }

        public boolean encode(CharBuffer cb, ByteBuffer bb, int escSeq, CodingErrorAction errorAction) {
            this.encoder.onMalformedInput(errorAction).onUnmappableCharacter(errorAction).reset();
            int cbmark = cb.position();
            int bbmark = bb.position();
            try {
                Encoder.escSeq(bb, escSeq);
                CoderResult cr = this.encoder.encode(cb, bb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = this.encoder.flush(bb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                cb.position(cbmark);
                bb.position(bbmark);
                return false;
            }
            return true;
        }

        public byte[] replacement() {
            return this.encoder.replacement();
        }
    }

    private static enum Codec {
        ISO_646("US-ASCII", true, 10306, 0, 1),
        ISO_8859_1("ISO-8859-1", true, 10306, 11585, 1),
        ISO_8859_2("ISO-8859-2", true, 10306, 11586, 1),
        ISO_8859_3("ISO-8859-3", true, 10306, 11587, 1),
        ISO_8859_4("ISO-8859-4", true, 10306, 11588, 1),
        ISO_8859_5("ISO-8859-5", true, 10306, 11596, 1),
        ISO_8859_6("ISO-8859-6", true, 10306, 11591, 1),
        ISO_8859_7("ISO-8859-7", true, 10306, 11590, 1),
        ISO_8859_8("ISO-8859-8", true, 10306, 11592, 1),
        ISO_8859_9("ISO-8859-9", true, 10306, 11597, 1),
        JIS_X_201("JIS_X0201", true, 10314, 10569, 1){

            @Override
            public String toText(String s) {
                return s.replace('\\', '\u00a5');
            }
        }
        ,
        TIS_620("TIS-620", true, 10306, 11604, 1),
        JIS_X_208("x-JIS0208", false, 9282, 0, 1),
        JIS_X_212("JIS_X0212-1990", false, 0x242844, 0, 2),
        KS_X_1001("EUC-KR", false, 10306, 2369859, -1),
        GB2312("GB2312", false, 10306, 2369857, -1),
        UTF_8("UTF-8", true, 0, 0, -1),
        GB18030("GB18030", false, 0, 0, -1);

        private final String charsetName;
        private final boolean containsASCII;
        private final int escSeq0;
        private final int escSeq1;
        private final int bytesPerChar;

        private Codec(String charsetName, boolean containsASCII, int escSeq0, int escSeq1, int bytesPerChar) {
            this.charsetName = charsetName;
            this.containsASCII = containsASCII;
            this.escSeq0 = escSeq0;
            this.escSeq1 = escSeq1;
            this.bytesPerChar = bytesPerChar;
        }

        public static Codec forCode(String code) {
            if (code == null) {
                return DEFAULT.codecs[0];
            }
            switch (Codec.last2digits(code)) {
                case 0: {
                    if (!code.equals("ISO_IR 100") && !code.equals("ISO 2022 IR 100")) break;
                    return ISO_8859_1;
                }
                case 1: {
                    if (!code.equals("ISO_IR 101") && !code.equals("ISO 2022 IR 101")) break;
                    return ISO_8859_2;
                }
                case 6: {
                    if (!code.equals("ISO 2022 IR 6")) break;
                    return DEFAULT.codecs[0];
                }
                case 9: {
                    if (!code.equals("ISO_IR 109") && !code.equals("ISO 2022 IR 109")) break;
                    return ISO_8859_3;
                }
                case 10: {
                    if (!code.equals("ISO_IR 110") && !code.equals("ISO 2022 IR 110")) break;
                    return ISO_8859_4;
                }
                case 13: {
                    if (!code.equals("ISO_IR 13") && !code.equals("ISO 2022 IR 13")) break;
                    return JIS_X_201;
                }
                case 26: {
                    if (!code.equals("ISO_IR 126") && !code.equals("ISO 2022 IR 126")) break;
                    return ISO_8859_7;
                }
                case 27: {
                    if (!code.equals("ISO_IR 127") && !code.equals("ISO 2022 IR 127")) break;
                    return ISO_8859_6;
                }
                case 30: {
                    if (!code.equals("GB18030")) break;
                    return GB18030;
                }
                case 31: {
                    if (!code.equals("GBK")) break;
                    return GB18030;
                }
                case 38: {
                    if (!code.equals("ISO_IR 138") && !code.equals("ISO 2022 IR 138")) break;
                    return ISO_8859_8;
                }
                case 44: {
                    if (!code.equals("ISO_IR 144") && !code.equals("ISO 2022 IR 144")) break;
                    return ISO_8859_5;
                }
                case 48: {
                    if (!code.equals("ISO_IR 148") && !code.equals("ISO 2022 IR 148")) break;
                    return ISO_8859_9;
                }
                case 49: {
                    if (!code.equals("ISO 2022 IR 149")) break;
                    return KS_X_1001;
                }
                case 58: {
                    if (!code.equals("ISO 2022 IR 58")) break;
                    return GB2312;
                }
                case 59: {
                    if (!code.equals("ISO 2022 IR 159")) break;
                    return JIS_X_212;
                }
                case 66: {
                    if (!code.equals("ISO_IR 166") && !code.equals("ISO 2022 IR 166")) break;
                    return TIS_620;
                }
                case 87: {
                    if (!code.equals("ISO 2022 IR 87")) break;
                    return JIS_X_208;
                }
                case 92: {
                    if (!code.equals("ISO_IR 192")) break;
                    return UTF_8;
                }
            }
            return DEFAULT.codecs[0];
        }

        private static int last2digits(String code) {
            int len = code.length();
            if (len < 2) {
                return -1;
            }
            char ch1 = code.charAt(len - 1);
            char ch2 = code.charAt(len - 2);
            return (ch2 & 0xF) * 10 + (ch1 & 0xF);
        }

        public byte[] encode(String val) {
            try {
                return val.getBytes(this.charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }

        public String decode(byte[] b, int off, int len) {
            try {
                return new String(b, off, len, this.charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }

        public boolean containsASCII() {
            return this.containsASCII;
        }

        public int getEscSeq0() {
            return this.escSeq0;
        }

        public int getEscSeq1() {
            return this.escSeq1;
        }

        public int getBytesPerChar() {
            return this.bytesPerChar;
        }

        public String toText(String s) {
            return s;
        }
    }
}

