/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.CancelListener;
import org.aoju.bus.image.metric.ProgressListener;

public class Progress
implements CancelListener {
    private final List<ProgressListener> list = new ArrayList<ProgressListener>();
    private Attributes attributes;
    private volatile boolean cancel = false;
    private File processedFile;
    private volatile boolean lastFailed = false;

    public Attributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Attributes attributes) {
        Progress progress = this;
        synchronized (progress) {
            int failed = this.getNumberOfFailedSuboperations();
            failed = failed < 0 ? 0 : failed;
            this.attributes = attributes;
            this.lastFailed = failed < this.getNumberOfFailedSuboperations();
        }
        this.fireProgress();
    }

    public boolean isLastFailed() {
        return this.lastFailed;
    }

    public synchronized File getProcessedFile() {
        return this.processedFile;
    }

    public synchronized void setProcessedFile(File processedFile) {
        this.processedFile = processedFile;
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener != null && !this.list.contains(listener)) {
            this.list.add(listener);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        if (listener != null) {
            this.list.remove(listener);
        }
    }

    private void fireProgress() {
        for (ProgressListener progressListener : this.list) {
            progressListener.handleProgression(this);
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private int getIntTag(int tag) {
        Attributes dcm = this.attributes;
        if (dcm == null) {
            return -1;
        }
        return dcm.getInt(tag, -1);
    }

    public int getStatus() {
        if (this.isCancel()) {
            return 65024;
        }
        Attributes dcm = this.attributes;
        if (dcm == null) {
            return 65280;
        }
        return dcm.getInt(2304, 65280);
    }

    public String getErrorComment() {
        Attributes dcm = this.attributes;
        if (dcm == null) {
            return null;
        }
        return dcm.getString(2306);
    }

    public int getNumberOfRemainingSuboperations() {
        return this.getIntTag(4128);
    }

    public int getNumberOfCompletedSuboperations() {
        return this.getIntTag(4129);
    }

    public int getNumberOfFailedSuboperations() {
        return this.getIntTag(4130);
    }

    public int getNumberOfWarningSuboperations() {
        return this.getIntTag(4131);
    }
}

