/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.IOException;
import java.net.Socket;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.acquire.HL7DeviceExtension;
import org.aoju.bus.image.metric.internal.hl7.HL7ConnectionMonitor;
import org.aoju.bus.image.metric.internal.hl7.HL7Exception;
import org.aoju.bus.image.metric.internal.hl7.HL7Message;
import org.aoju.bus.image.metric.internal.hl7.MLLPConnection;
import org.aoju.bus.image.metric.internal.hl7.UnparsedHL7Message;
import org.aoju.bus.image.metric.internal.net.TCPHandler;
import org.aoju.bus.logger.Logger;

public enum HL7Handler implements TCPHandler
{
    INSTANCE;


    @Override
    public void onAccept(Connection conn, Socket s) {
        conn.getDevice().execute(new HL7Receiver(conn, s));
    }

    private static class HL7Receiver
    implements Runnable {
        final Connection conn;
        final Socket s;
        final HL7DeviceExtension hl7dev;

        HL7Receiver(Connection conn, Socket s) {
            this.conn = conn;
            this.s = s;
            this.hl7dev = conn.getDevice().getDeviceExtensionNotNull(HL7DeviceExtension.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] data;
                this.s.setSoTimeout(this.conn.getIdleTimeout());
                MLLPConnection mllp = new MLLPConnection(this.s);
                while ((data = mllp.readMessage()) != null) {
                    UnparsedHL7Message rsp;
                    block10: {
                        HL7ConnectionMonitor monitor = this.hl7dev.getHL7ConnectionMonitor();
                        UnparsedHL7Message msg = new UnparsedHL7Message(data);
                        if (monitor != null) {
                            monitor.onMessageReceived(this.conn, this.s, msg);
                        }
                        try {
                            rsp = this.hl7dev.onMessage(this.conn, this.s, msg);
                            if (monitor != null) {
                                monitor.onMessageProcessed(this.conn, this.s, msg, rsp, null);
                            }
                        }
                        catch (HL7Exception e) {
                            rsp = new UnparsedHL7Message(HL7Message.makeACK(msg.msh(), e).getBytes(null));
                            if (monitor == null) break block10;
                            monitor.onMessageProcessed(this.conn, this.s, msg, rsp, e);
                        }
                    }
                    mllp.writeMessage(rsp.data());
                }
            }
            catch (IOException e) {
                Logger.warn("Exception on accepted connection {}:", this.s, e);
            }
            finally {
                this.conn.close(this.s);
            }
        }
    }
}

