/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.aoju.bus.image.metric.internal.hl7.Delimiter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HL7Parser {
    private static final String NAMESPACE = "http://aurora.regenstrief.org/xhl7";
    private final ContentHandler ch;
    private final AttributesImpl atts = new AttributesImpl();
    private final EnumSet<Delimiter> open = EnumSet.noneOf(Delimiter.class);
    private String namespace = "";
    private String delimiters;

    public HL7Parser(ContentHandler ch) {
        this.ch = ch;
    }

    public final boolean isIncludeNamespaceDeclaration() {
        return this.namespace == NAMESPACE;
    }

    public final void setIncludeNamespaceDeclaration(boolean includeNameSpaceDeclaration) {
        this.namespace = includeNameSpaceDeclaration ? NAMESPACE : "";
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this.parse(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader));
    }

    public void parse(BufferedReader reader) throws IOException, SAXException {
        String line;
        this.startDocument();
        this.delimiters = "|^~\\&";
        while ((line = reader.readLine()) != null) {
            String[] tks;
            if ((line = line.trim()).length() == 0) continue;
            if (line.length() < 3) {
                throw new IOException("Segment to short: " + line);
            }
            String seg = line.substring(0, 3);
            int tkindex = 0;
            if (this.isHeaderSegment(line)) {
                if (line.length() < 8) {
                    throw new IOException("Header Segment to short: " + line);
                }
                seg = line.substring(0, 3);
                this.setDelimiters(line.substring(3, 8));
                tks = this.tokenize(line.substring(8));
            } else {
                tks = this.tokenize(line);
                seg = tks[tkindex++];
            }
            this.startElement(seg);
            while (tkindex < tks.length) {
                String tk;
                Delimiter d;
                if ((d = this.delimiter(tk = tks[tkindex++])) != null) {
                    if (d != Delimiter.escape) {
                        this.endElement(d);
                        this.startElement(d);
                        continue;
                    }
                    if (tks.length > tkindex + 1 && tks[tkindex + 1].equals(tk)) {
                        int e;
                        if ((e = this.escapeIndex(tk = tks[tkindex++])) >= 0) {
                            this.ch.characters(this.delimiters.toCharArray(), e, 1);
                        } else {
                            this.startElement(Delimiter.escape.name());
                            this.ch.characters(tk.toCharArray(), 0, tk.length());
                            this.endElement(Delimiter.escape.name());
                        }
                        ++tkindex;
                        continue;
                    }
                }
                this.ch.characters(tk.toCharArray(), 0, tk.length());
            }
            this.endElement(Delimiter.field);
            this.endElement(seg);
        }
        this.endDocument();
    }

    private boolean isHeaderSegment(String line) {
        return line.startsWith("MSH") || line.startsWith("BHS") || line.startsWith("FHS");
    }

    private void startDocument() throws SAXException {
        this.ch.startDocument();
        this.addAttribute("xml-space", "preserved");
        this.startElement("hl7");
    }

    private void endDocument() throws SAXException {
        this.endElement("hl7");
        this.ch.endDocument();
    }

    private void setDelimiters(String delimiters) {
        Delimiter[] a = Delimiter.values();
        for (int i = 0; i < a.length; ++i) {
            this.addAttribute(a[i].attribute(), delimiters.substring(i, i + 1));
        }
        this.delimiters = delimiters;
    }

    private void addAttribute(String name, String value) {
        this.atts.addAttribute(this.namespace, name, name, "NMTOKEN", value);
    }

    private Delimiter delimiter(String tk) {
        if (tk.length() != 1) {
            return null;
        }
        int index = this.delimiters.indexOf(tk.charAt(0));
        return index >= 0 ? Delimiter.values()[index] : null;
    }

    private int escapeIndex(String tk) {
        return tk.length() != 1 ? "FSRET".indexOf(tk.charAt(0)) : -1;
    }

    private String[] tokenize(String s) {
        StringTokenizer stk = new StringTokenizer(s, this.delimiters, true);
        String[] tks = new String[stk.countTokens()];
        for (int i = 0; i < tks.length; ++i) {
            tks[i] = stk.nextToken();
        }
        return tks;
    }

    private void startElement(Delimiter d) throws SAXException {
        this.startElement(d.name());
        this.open.add(d);
    }

    private void startElement(String name) throws SAXException {
        this.ch.startElement(this.namespace, name, name, this.atts);
        this.atts.clear();
    }

    private void endElement(Delimiter delimiter) throws SAXException {
        Delimiter d = Delimiter.escape;
        do {
            if (!this.open.remove((Object)(d = d.parent()))) continue;
            this.endElement(d.name());
        } while (d != delimiter);
    }

    private void endElement(String name) throws SAXException {
        this.ch.endElement(this.namespace, name, name);
    }
}

