/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble;

import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.aoju.bus.image.nimble.PaletteColorModel;

public class BufferedImages {
    private BufferedImages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertToIntRGB(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        if (cm instanceof DirectColorModel) {
            return bi;
        }
        if (cm.getNumComponents() != 3) {
            throw new IllegalArgumentException("ColorModel: " + cm);
        }
        WritableRaster raster = bi.getRaster();
        if (cm instanceof PaletteColorModel) {
            return ((PaletteColorModel)cm).convertToIntDiscrete(raster);
        }
        BufferedImage intRGB = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
        Graphics graphics = intRGB.getGraphics();
        try {
            graphics.drawImage(bi, 0, 0, null);
        }
        finally {
            graphics.dispose();
        }
        return intRGB;
    }

    public static BufferedImage convertYBRtoRGB(BufferedImage src, BufferedImage dst) {
        if (src.getColorModel().getTransferType() != 0) {
            throw new UnsupportedOperationException("Cannot convert color model to RGB: unsupported transferType" + src.getColorModel().getTransferType());
        }
        if (src.getColorModel().getNumComponents() != 3) {
            throw new IllegalArgumentException("Unsupported colorModel: " + src.getColorModel());
        }
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            ComponentColorModel cmodel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            SampleModel sampleModel = ((ColorModel)cmodel).createCompatibleSampleModel(width, height);
            DataBuffer dataBuffer = sampleModel.createDataBuffer();
            WritableRaster rasterDst = Raster.createWritableRaster(sampleModel, dataBuffer, null);
            dst = new BufferedImage(cmodel, rasterDst, false, null);
        }
        WritableRaster rasterDst = dst.getRaster();
        WritableRaster raster = src.getRaster();
        ColorSpace cs = src.getColorModel().getColorSpace();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                byte[] ba = (byte[])raster.getDataElements(j, i, null);
                float[] fba = new float[]{(float)(ba[0] & 0xFF) / 255.0f, (float)(ba[1] & 0xFF) / 255.0f, (float)(ba[2] & 0xFF) / 255.0f};
                float[] rgb = cs.toRGB(fba);
                ba[0] = (byte)(rgb[0] * 255.0f);
                ba[1] = (byte)(rgb[1] * 255.0f);
                ba[2] = (byte)(rgb[2] * 255.0f);
                rasterDst.setDataElements(j, i, ba);
            }
        }
        return dst;
    }

    public static BufferedImage convertPalettetoRGB(BufferedImage src, BufferedImage dst) {
        ColorModel pcm = src.getColorModel();
        if (!(pcm instanceof PaletteColorModel)) {
            throw new UnsupportedOperationException("Cannot convert " + pcm.getClass().getName() + " to RGB");
        }
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            ComponentColorModel cmodel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            SampleModel sampleModel = ((ColorModel)cmodel).createCompatibleSampleModel(width, height);
            DataBuffer dataBuffer = sampleModel.createDataBuffer();
            WritableRaster rasterDst = Raster.createWritableRaster(sampleModel, dataBuffer, null);
            dst = new BufferedImage(cmodel, rasterDst, false, null);
        }
        WritableRaster rasterDst = dst.getRaster();
        WritableRaster raster = src.getRaster();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                byte[] b = BufferedImages.convertTo3Bytes(pcm, raster.getDataElements(j, i, null));
                rasterDst.setDataElements(j, i, b);
            }
        }
        return dst;
    }

    private static byte[] convertTo3Bytes(ColorModel pm, Object data) {
        int pix;
        byte[] b = new byte[3];
        if (data instanceof byte[]) {
            byte[] pixels = (byte[])data;
            pix = pm.getRGB(pixels[0]);
        } else {
            short[] pixels = (short[])data;
            pix = pm.getRGB(pixels[0]);
        }
        b[0] = (byte)(pix >> 16 & 0xFF);
        b[1] = (byte)(pix >> 8 & 0xFF);
        b[2] = (byte)(pix & 0xFF);
        return b;
    }
}

