/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.jboss;

import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.AbstractAware;
import org.aoju.bus.logger.level.Level;
import org.jboss.logging.Logger;

public class JbossLog
extends AbstractAware {
    private final transient Logger logger;

    public JbossLog(Logger logger) {
        this.logger = logger;
    }

    public JbossLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JbossLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTrace() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isTrace()) {
            this.logger.trace(fqcn, (Object)StringKit.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isDebug()) {
            this.logger.debug(fqcn, (Object)StringKit.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfo() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isInfo()) {
            this.logger.info(fqcn, (Object)StringKit.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarn() {
        return this.logger.isEnabled(Logger.Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isWarn()) {
            this.logger.warn(fqcn, (Object)StringKit.format(format, arguments), t);
        }
    }

    @Override
    public boolean isError() {
        return this.logger.isEnabled(Logger.Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isError()) {
            this.logger.error(fqcn, (Object)StringKit.format(format, arguments), t);
        }
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(fqcn, t, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(fqcn, t, format, arguments);
                break;
            }
            case INFO: {
                this.info(fqcn, t, format, arguments);
                break;
            }
            case WARN: {
                this.warn(fqcn, t, format, arguments);
                break;
            }
            case ERROR: {
                this.error(fqcn, t, format, arguments);
                break;
            }
            default: {
                throw new Error(StringKit.format("Can not identify level: {}", new Object[]{level}));
            }
        }
    }
}

