/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class AlipayProvider
extends AbstractProvider {
    private final AlipayClient alipayClient;

    public AlipayProvider(Context context) {
        super(context, Registry.ALIPAY);
        this.alipayClient = new DefaultAlipayClient(Registry.ALIPAY.accessToken(), context.getAppKey(), context.getAppSecret(), "json", "UTF-8", context.getPublicKey(), "RSA2");
    }

    public AlipayProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.ALIPAY, extendCache);
        this.alipayClient = new DefaultAlipayClient(Registry.ALIPAY.accessToken(), context.getAppKey(), context.getAppSecret(), "json", "UTF-8", context.getPublicKey(), "RSA2");
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        AlipaySystemOauthTokenResponse response;
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("authorization_code");
        request.setCode(callback.getAuth_code());
        try {
            response = (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            throw new AuthorizedException(e);
        }
        if (!response.isSuccess()) {
            throw new AuthorizedException(response.getSubMsg());
        }
        return AccToken.builder().accessToken(response.getAccessToken()).uid(response.getUserId()).expireIn(Integer.parseInt(response.getExpiresIn())).refreshToken(response.getRefreshToken()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        AlipaySystemOauthTokenResponse response;
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("refresh_token");
        request.setRefreshToken(accToken.getRefreshToken());
        try {
            response = (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            throw new AuthorizedException(e);
        }
        if (!response.isSuccess()) {
            throw new AuthorizedException(response.getSubMsg());
        }
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(AccToken.builder().accessToken(response.getAccessToken()).uid(response.getUserId()).expireIn(Integer.parseInt(response.getExpiresIn())).refreshToken(response.getRefreshToken()).build()).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        AlipayUserInfoShareResponse object;
        String accessToken = accToken.getAccessToken();
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        try {
            object = (AlipayUserInfoShareResponse)this.alipayClient.execute((AlipayRequest)request, accessToken);
        }
        catch (AlipayApiException e) {
            throw new AuthorizedException(e.getErrMsg(), e);
        }
        if (!object.isSuccess()) {
            throw new AuthorizedException(object.getSubMsg());
        }
        String province = object.getProvince();
        String city = object.getCity();
        String location = String.format("%s %s", StringKit.isEmpty(province) ? "" : province, StringKit.isEmpty(city) ? "" : city);
        return Property.builder().rawJson(JSONObject.parseObject((String)JSONObject.toJSONString((Object)object))).uuid(object.getUserId()).username(StringKit.isEmpty(object.getUserName()) ? object.getNickName() : object.getUserName()).nickname(object.getNickName()).avatar(object.getAvatar()).location(location).gender(Normal.Gender.getGender(object.getGender())).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("app_id", this.context.getAppKey()).queryParam("scope", "auth_user").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }
}

