/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class BaiduProvider
extends AbstractProvider {
    public BaiduProvider(Context context) {
        super(context, Registry.BAIDU);
    }

    public BaiduProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.BAIDU, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        return this.getAuthToken(response);
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("userid")).username(object.getString("username")).nickname(object.getString("username")).avatar(this.getAvatar(object)).remark(object.getString("userdetail")).gender(Normal.Gender.getGender(object.getString("sex"))).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message revoke(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetRevoke(token));
        this.checkResponse(object);
        Builder.ErrorCode status = object.getIntValue("result") == 1 ? Builder.ErrorCode.SUCCESS : Builder.ErrorCode.FAILURE;
        return Message.builder().errcode(status.getCode()).errmsg(status.getMsg()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        String refreshUrl = Builder.fromUrl(this.source.refresh()).queryParam("grant_type", "refresh_token").queryParam("refresh_token", accToken.getRefreshToken()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).build();
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getAuthToken(Httpx.get(refreshUrl))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("display", "popup").queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error") || object.containsKey((Object)"error_code")) {
            String msg = object.containsKey((Object)"error_description") ? object.getString("error_description") : object.getString("error_msg");
            throw new AuthorizedException(msg);
        }
    }

    private String getAvatar(JSONObject object) {
        String protrait = object.getString("portrait");
        return StringKit.isEmpty(protrait) ? null : String.format("http://himg.bdimg.com/sys/portrait/item/%s.jpg", protrait);
    }

    private AccToken getAuthToken(String json) {
        JSONObject object = JSONObject.parseObject((String)json);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).scope(object.getString("scope")).expireIn(object.getIntValue("expires_in")).build();
    }
}

