/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class GithubProvider
extends AbstractProvider {
    public GithubProvider(Context context) {
        super(context, Registry.GITHUB);
    }

    public GithubProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.GITHUB, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        Map<String, String> paramMap = UriKit.decodeVal(this.doPostAuthorizationCode(callback.getCode()), "UTF-8");
        this.checkResponse(paramMap.containsKey("error"), paramMap.get("error_description"));
        return AccToken.builder().accessToken(paramMap.get("access_token")).scope(paramMap.get("scope")).tokenType(paramMap.get("token_type")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(object.containsKey((Object)"error"), object.getString("error_description"));
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(object.getString("login")).avatar(object.getString("avatar_url")).blog(object.getString("blog")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).email(object.getString("email")).remark(object.getString("bio")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    private void checkResponse(boolean error, String error_description) {
        if (error) {
            throw new AuthorizedException(error_description);
        }
    }
}

