/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class KujialeProvider
extends AbstractProvider {
    public KujialeProvider(Context context) {
        super(context, Registry.KUJIALE);
    }

    public KujialeProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.KUJIALE, extendCache);
    }

    @Override
    public String authorize(String state) {
        return this.authorize(state, "get_user_info");
    }

    public String authorize(String state, String scopeStr) {
        Builder builder = Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state));
        if (StringKit.isNotEmpty(scopeStr)) {
            builder.queryParam("scope", scopeStr);
        }
        return builder.build();
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getAuthToken(this.doPostAuthorizationCode(callback.getCode()));
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String openId = this.getOpenId(accToken);
        String response = Httpx.get(Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("open_id", openId).build());
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        if (!"0".equals(jsonObject.getString("c"))) {
            throw new AuthorizedException(jsonObject.getString("m"));
        }
        JSONObject object = jsonObject.getJSONObject("d");
        return Property.builder().rawJson(object).username(object.getString("userName")).nickname(object.getString("userName")).avatar(object.getString("avatar")).uuid(object.getString("openId")).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        String response = Httpx.post(this.refreshTokenUrl(accToken.getRefreshToken()));
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    private AccToken getAuthToken(String response) {
        JSONObject object = this.checkResponse(response);
        JSONObject resultObject = object.getJSONObject("d");
        return AccToken.builder().accessToken(resultObject.getString("accessToken")).refreshToken(resultObject.getString("refreshToken")).expireIn(resultObject.getIntValue("expiresIn")).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (!"0".equals(object.getString("c"))) {
            throw new AuthorizedException(object.getString("m"));
        }
        return object;
    }

    private String getOpenId(AccToken accToken) {
        String response = Httpx.get(Builder.fromUrl("https://oauth.kujiale.com/oauth2/auth/user").queryParam("access_token", accToken.getAccessToken()).build());
        JSONObject accessTokenObject = this.checkResponse(response);
        return accessTokenObject.getString("d");
    }
}

