/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class PinterestProvider
extends AbstractProvider {
    private static final String FAILURE = "failure";

    public PinterestProvider(Context context) {
        super(context, Registry.PINTEREST);
    }

    public PinterestProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.PINTEREST, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject accessTokenObject = JSONObject.parseObject((String)this.doPostAuthorizationCode(callback.getCode()));
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).tokenType(accessTokenObject.getString("token_type")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String userinfoUrl = this.userInfoUrl(accToken);
        JSONObject jsonObject = JSONObject.parseObject((String)Httpx.get(userinfoUrl));
        this.checkResponse(jsonObject);
        JSONObject object = jsonObject.getJSONObject("data");
        return Property.builder().rawJson(object).uuid(object.getString("id")).avatar(this.getAvatarUrl(object)).username(object.getString("username")).nickname(object.getString("first_name") + " " + object.getString("last_name")).gender(Normal.Gender.UNKNOWN).remark(object.getString("bio")).token(accToken).source(this.source.toString()).build();
    }

    private String getAvatarUrl(JSONObject jsonObject) {
        JSONObject object = jsonObject.getJSONObject("image");
        if (Objects.isNull(object)) {
            return null;
        }
        return object.getJSONObject("60x60").getString("url");
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "read_public").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("fields", "id,username,first_name,last_name,bio,image").build();
    }

    private void checkResponse(JSONObject object) {
        if (!object.containsKey((Object)"status") && FAILURE.equals(object.getString("status"))) {
            throw new AuthorizedException(object.getString("message"));
        }
    }
}

