/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.bridge;

import java.io.File;
import java.util.stream.IntStream;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.office.bridge.OnlineOfficeEntryBuilder;
import org.aoju.bus.office.bridge.OnlineOfficeEntryManager;
import org.aoju.bus.office.bridge.OnlineOfficePoolBuilder;
import org.aoju.bus.office.metric.AbstractOfficePoolManager;
import org.aoju.bus.office.metric.InstalledOfficeHolder;

public final class OnlineOfficePoolManager
extends AbstractOfficePoolManager {
    private final int poolSize;
    private final String urlConnection;

    private OnlineOfficePoolManager(int poolSize, String urlConnection, OnlineOfficePoolBuilder config) {
        super(poolSize, config);
        this.poolSize = poolSize;
        this.urlConnection = urlConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OnlineOfficePoolManager make(String urlConnection) {
        return OnlineOfficePoolManager.builder().urlConnection(urlConnection).build();
    }

    public static OnlineOfficePoolManager install(String urlConnection) {
        return ((Builder)OnlineOfficePoolManager.builder().urlConnection(urlConnection).install()).build();
    }

    protected OnlineOfficeEntryManager[] createPoolEntries() {
        return (OnlineOfficeEntryManager[])IntStream.range(0, this.poolSize).mapToObj(idx -> new OnlineOfficeEntryManager(this.urlConnection, (OnlineOfficeEntryBuilder)((Object)this.config))).toArray(OnlineOfficeEntryManager[]::new);
    }

    public static final class Builder
    extends AbstractOfficePoolManager.AbstractOfficeManagerPoolBuilder<Builder> {
        private int poolSize = 1;
        private String urlConnection;

        private Builder() {
        }

        @Override
        public OnlineOfficePoolManager build() {
            Assert.notEmpty(this.urlConnection, "The URL connection is missing", new Object[0]);
            if (this.workingDir == null) {
                this.workingDir = new File(System.getProperty("java.io.tmpdir"));
            }
            OnlineOfficePoolBuilder config = new OnlineOfficePoolBuilder(this.workingDir);
            config.setTaskExecutionTimeout(this.taskExecutionTimeout);
            config.setTaskQueueTimeout(this.taskQueueTimeout);
            OnlineOfficePoolManager manager = new OnlineOfficePoolManager(this.poolSize, this.urlConnection, config);
            if (this.install) {
                InstalledOfficeHolder.setInstance(manager);
            }
            return manager;
        }

        public Builder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public Builder urlConnection(String urlConnection) {
            this.urlConnection = urlConnection;
            return this;
        }
    }
}

