/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.XTransferableSupplier;
import com.sun.star.frame.XController;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.view.XSelectionSupplier;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class PageSelectorFilter
implements Filter {
    private final int page;

    public PageSelectorFilter(int page) {
        this.page = page;
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            this.selectPage(document);
        }
        chain.doFilter(context, document);
    }

    private void selectPage(XComponent document) throws Exception {
        XTextDocument docText = Write.getTextDoc(document);
        XController controller = docText.getCurrentController();
        XTextCursor textCursor = docText.getText().createTextCursor();
        XTextViewCursor viewCursor = Lo.qi(XTextViewCursorSupplier.class, controller).getViewCursor();
        textCursor.gotoStart(false);
        viewCursor.gotoStart(false);
        XPageCursor pageCursor = Lo.qi(XPageCursor.class, viewCursor);
        pageCursor.jumpToPage((short)this.page);
        textCursor.gotoRange(viewCursor.getStart(), false);
        pageCursor.jumpToEndOfPage();
        textCursor.gotoRange(viewCursor.getStart(), true);
        XSelectionSupplier selectionSupplier = Lo.qi(XSelectionSupplier.class, controller);
        selectionSupplier.select((Object)textCursor);
        XTransferableSupplier transferableSupplier = Lo.qi(XTransferableSupplier.class, controller);
        XTransferable xTransferable = transferableSupplier.getTransferable();
        textCursor.gotoStart(false);
        textCursor.gotoEnd(true);
        selectionSupplier.select((Object)textCursor);
        transferableSupplier.insertTransferable(xTransferable);
    }
}

