/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import org.aoju.bus.core.toolkit.StringKit;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StyleKit {
    public static CellStyle cloneCellStyle(Cell cell, CellStyle cellStyle) {
        return StyleKit.cloneCellStyle(cell.getSheet().getWorkbook(), cellStyle);
    }

    public static CellStyle cloneCellStyle(Workbook workbook, CellStyle cellStyle) {
        CellStyle newCellStyle = workbook.createCellStyle();
        newCellStyle.cloneStyleFrom(cellStyle);
        return newCellStyle;
    }

    public static CellStyle setAlign(CellStyle cellStyle, HorizontalAlignment halign, VerticalAlignment valign) {
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        return cellStyle;
    }

    public static CellStyle setBorder(CellStyle cellStyle, BorderStyle borderSize, IndexedColors colorIndex) {
        cellStyle.setBorderBottom(borderSize);
        cellStyle.setBottomBorderColor(colorIndex.index);
        cellStyle.setBorderLeft(borderSize);
        cellStyle.setLeftBorderColor(colorIndex.index);
        cellStyle.setBorderRight(borderSize);
        cellStyle.setRightBorderColor(colorIndex.index);
        cellStyle.setBorderTop(borderSize);
        cellStyle.setTopBorderColor(colorIndex.index);
        return cellStyle;
    }

    public static CellStyle setColor(CellStyle cellStyle, IndexedColors color, FillPatternType fillPattern) {
        return StyleKit.setColor(cellStyle, color.index, fillPattern);
    }

    public static CellStyle setColor(CellStyle cellStyle, short color, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(color);
        cellStyle.setFillPattern(fillPattern);
        return cellStyle;
    }

    public static Font createFont(Workbook workbook, short color, short fontSize, String fontName) {
        Font font = workbook.createFont();
        return StyleKit.setFontStyle(font, color, fontSize, fontName);
    }

    public static Font setFontStyle(Font font, short color, short fontSize, String fontName) {
        if (color > 0) {
            font.setColor(color);
        }
        if (fontSize > 0) {
            font.setFontHeightInPoints(fontSize);
        }
        if (StringKit.isNotBlank(fontName)) {
            font.setFontName(fontName);
        }
        return font;
    }

    public static CellStyle createDefaultCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        StyleKit.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StyleKit.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        return cellStyle;
    }

    public static CellStyle createHeadCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        StyleKit.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StyleKit.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        StyleKit.setColor(cellStyle, IndexedColors.GREY_25_PERCENT, FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }
}

