/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.StrBuilder;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.aoju.bus.office.support.excel.sax.AbstractExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.CellDataType;
import org.aoju.bus.office.support.excel.sax.RowHandler;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class Excel07SaxReader
extends AbstractExcelSaxReader<Excel07SaxReader>
implements ContentHandler {
    private static final String RID_PREFIX = "rId";
    private final StrBuilder lastContent = StringKit.strBuilder();
    private StylesTable stylesTable;
    private SharedStringsTable sharedStringsTable;
    private int sheetIndex;
    private int index;
    private int curCell;
    private CellDataType cellDataType;
    private long rowNumber;
    private String curCoordinate;
    private String preCoordinate;
    private String maxCellCoordinate;
    private XSSFCellStyle xssfCellStyle;
    private String numFmtString;
    private List<Object> rowCellList = new ArrayList<Object>();
    private RowHandler rowHandler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws InstrumentException {
        try {
            return this.read(OPCPackage.open((File)file), rid);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws InstrumentException {
        try {
            return this.read(OPCPackage.open((InputStream)in), rid);
        }
        catch (InstrumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws InstrumentException {
        InputStream sheetInputStream = null;
        try {
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            try {
                this.stylesTable = xssfReader.getStylesTable();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sharedStringsTable = xssfReader.getSharedStringsTable();
            if (rid > -1) {
                this.sheetIndex = rid;
                sheetInputStream = xssfReader.getSheet(RID_PREFIX + (rid + 1));
                ExcelSaxKit.readFrom(sheetInputStream, this);
            } else {
                this.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.index = 0;
                    ++this.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxKit.readFrom(sheetInputStream, this);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(sheetInputStream);
            IoKit.close((Closeable)opcPackage);
        }
        return this;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (ElementName.row.match(localName)) {
            this.startRow(attributes);
        } else if (ElementName.c.match(localName)) {
            this.startCell(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (ElementName.c.match(localName)) {
            this.endCell();
        } else if (ElementName.row.match(localName)) {
            this.endRow();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.lastContent.append(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    private void startRow(Attributes attributes) {
        this.rowNumber = Long.parseLong(AttributeName.r.getValue(attributes)) - 1L;
    }

    private void startCell(Attributes attributes) {
        String tempCurCoordinate = AttributeName.r.getValue(attributes);
        this.preCoordinate = this.preCoordinate == null ? String.valueOf('@') : this.curCoordinate;
        this.curCoordinate = tempCurCoordinate;
        this.setCellType(attributes);
        this.lastContent.reset();
    }

    private void endCell() {
        String contentStr = StringKit.trim(this.lastContent);
        Object value = ExcelSaxKit.getDataValue(this.cellDataType, contentStr, this.sharedStringsTable, this.numFmtString);
        this.fillBlankCell(this.preCoordinate, this.curCoordinate, false);
        this.addCellValue(this.curCell++, value);
    }

    private void endRow() {
        if (this.index == 0) {
            this.maxCellCoordinate = this.curCoordinate;
        }
        if (this.maxCellCoordinate != null) {
            this.fillBlankCell(this.curCoordinate, this.maxCellCoordinate, true);
        }
        this.rowHandler.handle(this.sheetIndex, this.rowNumber, this.rowCellList);
        this.rowCellList = new ArrayList<Object>(this.curCell + 1);
        ++this.index;
        this.curCell = 0;
        this.curCoordinate = null;
        this.preCoordinate = null;
    }

    private void addCellValue(int index, Object value) {
        this.rowCellList.add(index, value);
        this.rowHandler.handleCell(this.sheetIndex, this.rowNumber, index, value, (CellStyle)this.xssfCellStyle);
    }

    private void fillBlankCell(String preCoordinate, String curCoordinate, boolean isEnd) {
        if (!curCoordinate.equals(preCoordinate)) {
            int len = ExcelSaxKit.countNullCell(preCoordinate, curCoordinate);
            if (isEnd) {
                // empty if block
            }
            while (true) {
                int n = ++len;
                --len;
                if (n <= 0) break;
                this.addCellValue(this.curCell++, "");
            }
        }
    }

    private void setCellType(Attributes attributes) {
        String xfIndexStr;
        this.numFmtString = "";
        this.cellDataType = CellDataType.of(AttributeName.t.getValue(attributes));
        if (null != this.stylesTable && null != (xfIndexStr = AttributeName.s.getValue(attributes))) {
            int xfIndex = Integer.parseInt(xfIndexStr);
            this.xssfCellStyle = this.stylesTable.getStyleAt(xfIndex);
            this.numFmtString = this.xssfCellStyle.getDataFormatString();
            short numFmtIndex = this.xssfCellStyle.getDataFormat();
            if (this.numFmtString == null) {
                this.numFmtString = BuiltinFormats.getBuiltinFormat((int)numFmtIndex);
            } else if (CellDataType.NUMBER == this.cellDataType && DateUtil.isADateFormat((int)numFmtIndex, (String)this.numFmtString)) {
                this.cellDataType = CellDataType.DATE;
            }
        }
    }

    public static enum AttributeName {
        r,
        s,
        t;


        public boolean match(String attributeName) {
            return this.name().equals(attributeName);
        }

        public String getValue(Attributes attributes) {
            return attributes.getValue(this.name());
        }
    }

    public static enum ElementName {
        row,
        c;


        public boolean match(String elementName) {
            return this.name().equals(elementName);
        }
    }
}

