/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.QuickTimer;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.plugins.Plugin;

public final class MonitorPlugin<T>
extends TimerTask
implements Plugin<T> {
    private int seconds = 0;
    private AtomicLong inFlow = new AtomicLong(0L);
    private AtomicLong outFlow = new AtomicLong(0L);
    private AtomicLong processFailNum = new AtomicLong(0L);
    private AtomicLong processMsgNum = new AtomicLong(0L);
    private AtomicLong totleProcessMsgNum = new AtomicLong(0L);
    private AtomicInteger newConnect = new AtomicInteger(0);
    private AtomicInteger disConnect = new AtomicInteger(0);
    private AtomicInteger onlineCount = new AtomicInteger(0);
    private AtomicInteger totalConnect = new AtomicInteger(0);

    public MonitorPlugin() {
        this(60);
    }

    public MonitorPlugin(int seconds) {
        this.seconds = seconds;
        long mills = TimeUnit.SECONDS.toMillis(seconds);
        QuickTimer.getTimer().schedule((TimerTask)this, mills, mills);
    }

    @Override
    public boolean preProcess(AioSession<T> session, T t) {
        this.processMsgNum.incrementAndGet();
        this.totleProcessMsgNum.incrementAndGet();
        return true;
    }

    @Override
    public void stateEvent(StateMachine stateMachineEnum, AioSession<T> session, Throwable throwable) {
        switch (stateMachineEnum) {
            case PROCESS_EXCEPTION: {
                this.processFailNum.incrementAndGet();
                break;
            }
            case NEW_SESSION: {
                this.newConnect.incrementAndGet();
                break;
            }
            case SESSION_CLOSED: {
                this.disConnect.incrementAndGet();
            }
        }
    }

    @Override
    public void run() {
        long curInFlow = this.inFlow.getAndSet(0L);
        long curOutFlow = this.outFlow.getAndSet(0L);
        long curDiscardNum = this.processFailNum.getAndSet(0L);
        long curProcessMsgNum = this.processMsgNum.getAndSet(0L);
        int connectCount = this.newConnect.getAndSet(0);
        int disConnectCount = this.disConnect.getAndSet(0);
        Logger.info("\r\n-----\u8fd9" + this.seconds + "\u79d2\u53d1\u751f\u4e86\u4ec0\u4e48----\r\n\u6d41\u5165\u6d41\u91cf:\t\t" + (double)curInFlow * 1.0 / 1048576.0 + "(MB)\r\n\u6d41\u51fa\u6d41\u91cf:\t" + (double)curOutFlow * 1.0 / 1048576.0 + "(MB)\r\n\u5904\u7406\u5931\u8d25\u6d88\u606f\u6570:\t" + curDiscardNum + "\r\n\u5df2\u5904\u7406\u6d88\u606f\u91cf:\t" + curProcessMsgNum + "\r\n\u5df2\u5904\u7406\u6d88\u606f\u603b\u91cf:\t" + this.totleProcessMsgNum.get() + "\r\n\u65b0\u5efa\u8fde\u63a5\u6570:\t" + connectCount + "\r\n\u65ad\u5f00\u8fde\u63a5\u6570:\t" + disConnectCount + "\r\n\u5728\u7ebf\u8fde\u63a5\u6570:\t" + this.onlineCount.addAndGet(connectCount - disConnectCount) + "\r\n\u603b\u8fde\u63a5\u6b21\u6570:\t" + this.totalConnect.addAndGet(connectCount) + "\r\nRequests/sec:\t" + (double)curProcessMsgNum * 1.0 / (double)this.seconds + "\r\nTransfer/sec:\t" + (double)curInFlow * 1.0 / 1048576.0 / (double)this.seconds + "(MB)", new Object[0]);
    }

    @Override
    public boolean acceptMonitor(AsynchronousSocketChannel channel) {
        return true;
    }

    @Override
    public void readMonitor(AioSession<T> session, int readSize) {
        if (readSize == 0) {
            Logger.error("readSize is 0", new Object[0]);
        }
        this.inFlow.addAndGet(readSize);
    }

    @Override
    public void writeMonitor(AioSession<T> session, int writeSize) {
        this.outFlow.addAndGet(writeSize);
    }
}

