/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.base.consts;

import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.Symbol;

/**
 * 公共常量
 *
 * @author Kimi Liu
 * @version 6.0.5
 * @since JDK 1.8+
 */
public class Consts extends Normal {

    /**
     * 全局状态
     */
    public static final String STATUS_MINUS_ONE = "-1";
    public static final String STATUS_ZERO = Symbol.ZERO;
    public static final String STATUS_ONE = Symbol.ONE;
    public static final String STATUS_TWO = Symbol.TWO;
    public static final String STATUS_THREE = Symbol.THREE;
    public static final String STATUS_FOUR = Symbol.FOUR;
    public static final String STATUS_FIVE = Symbol.FIVE;
    public static final String STATUS_SIX = Symbol.SIX;
    public static final String STATUS_SEVEN = Symbol.SEVEN;
    public static final String STATUS_EIGHT = Symbol.EIGHT;
    public static final String STATUS_NINE = Symbol.NINE;

    /**
     * 全局类型
     */
    public static final String TYPE_ZERO = Symbol.ZERO;
    public static final String TYPE_ONE = Symbol.ONE;
    public static final String TYPE_TWO = Symbol.TWO;
    public static final String TYPE_THREE = Symbol.THREE;
    public static final String TYPE_FOUR = Symbol.FOUR;
    public static final String TYPE_FIVE = Symbol.FIVE;
    public static final String TYPE_SIX = Symbol.SIX;
    public static final String TYPE_SEVEN = Symbol.SEVEN;
    public static final String TYPE_EIGHT = Symbol.EIGHT;
    public static final String TYPE_NINE = Symbol.NINE;

}
