/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.cache.magic;

/**
 * @author Kimi Liu
 * @version 6.0.5
 * @since JDK 1.8+
 */
public interface CacheExpire {

    int NO = -1;

    int FOREVER = 0;

    int ONE_SEC = 1000;

    int FIVE_SEC = 4 * ONE_SEC;

    int TEN_SEC = 2 * FIVE_SEC;

    int ONE_MIN = 6 * TEN_SEC;

    int FIVE_MIN = 5 * ONE_MIN;

    int TEN_MIN = 2 * FIVE_MIN;

    int HALF_HOUR = 30 * TEN_MIN;

    int ONE_HOUR = 2 * HALF_HOUR;

    int TWO_HOUR = 2 * ONE_HOUR;

    int SIX_HOUR = 3 * TWO_HOUR;

    int TWELVE_HOUR = 2 * SIX_HOUR;

    int ONE_DAY = 2 * TWELVE_HOUR;

    int TWO_DAY = 2 * ONE_DAY;

    int ONE_WEEK = 7 * ONE_DAY;

}
