/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.forest.archive;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.forest.Complex;
import org.aoju.bus.forest.algorithm.Key;
import org.aoju.bus.forest.provider.EncryptorProvider;
import org.aoju.bus.forest.provider.EntryEncryptorProvider;

public class DirEncryptorProvider
extends EntryEncryptorProvider<File>
implements EncryptorProvider {
    public DirEncryptorProvider(EncryptorProvider encryptorProvider) {
        this(encryptorProvider, (Complex<File>)null);
    }

    public DirEncryptorProvider(EncryptorProvider encryptorProvider, Complex<File> filter) {
        super(encryptorProvider, filter);
    }

    @Override
    public void encrypt(Key key, File src, File dest) throws IOException {
        if (src.isFile()) {
            EncryptorProvider encryptor = this.on(src) ? this.encryptorProvider : this.xNopEncryptor;
            encryptor.encrypt(key, src, dest);
        } else if (src.isDirectory()) {
            File[] files = src.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                this.encrypt(key, files[i], new File(dest, files[i].getName()));
            }
        }
    }
}

