/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.aoju.bus.image.nimble.opencv.NativeImageReader;
import org.aoju.bus.image.nimble.opencv.NativeJLSImageWriterSpi;

public class NativeJLSImageReaderSpi
extends ImageReaderSpi {
    public static final String[] NAMES = new String[]{"jpeg-ls-cv", "jpeg-ls", "JPEG-LS"};
    public static final String[] SUFFIXES = new String[]{"jls"};
    public static final String[] MIMES = new String[]{"image/jpeg-ls"};

    public NativeJLSImageReaderSpi() {
        super("Bus Team", "1.5", NAMES, SUFFIXES, MIMES, NativeImageReader.class.getName(), new Class[]{ImageInputStream.class}, new String[]{NativeJLSImageWriterSpi.class.getName()}, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Natively-accelerated JPEG-LS Image Reader (CharLS based)";
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        int byte1 = iis.read();
        int byte2 = iis.read();
        int byte3 = iis.read();
        int byte4 = iis.read();
        iis.reset();
        return byte1 == 255 && byte2 == 216 && byte3 == 255 && byte4 == 247;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new NativeImageReader(this, false);
    }
}

