/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;

public class TiledAlgorithm {
    private final int mTileSize;
    private final int mPadding;
    private final int mBorderType;

    TiledAlgorithm(int tileSize, int padding, int borderType) {
        this.mTileSize = tileSize;
        this.mPadding = padding;
        this.mBorderType = borderType;
    }

    void process(Mat sourceImage, Mat resultImage) {
        if (sourceImage.rows() != resultImage.rows() || sourceImage.cols() != resultImage.cols()) {
            throw new IllegalStateException("");
        }
        int rows = sourceImage.rows() / this.mTileSize + (sourceImage.rows() % this.mTileSize != 0 ? 1 : 0);
        int cols = sourceImage.cols() / this.mTileSize + (sourceImage.cols() % this.mTileSize != 0 ? 1 : 0);
        Mat tileInput = new Mat();
        Mat tileOutput = new Mat();
        for (int rowTile = 0; rowTile < rows; ++rowTile) {
            for (int colTile = 0; colTile < cols; ++colTile) {
                Rect srcTile = new Rect(colTile * this.mTileSize - this.mPadding, rowTile * this.mTileSize - this.mPadding, this.mTileSize + 2 * this.mPadding, this.mTileSize + 2 * this.mPadding);
                Rect dstTile = new Rect(colTile * this.mTileSize, rowTile * this.mTileSize, this.mTileSize, this.mTileSize);
                this.copySourceTile(sourceImage, tileInput, srcTile);
                this.processTileImpl(tileInput, tileOutput);
                this.copyTileToResultImage(tileOutput, resultImage, dstTile);
            }
        }
    }

    private void copyTileToResultImage(Mat tileOutput, Mat resultImage, Rect dstTile) {
        Rect srcTile = new Rect(this.mPadding, this.mPadding, this.mTileSize, this.mTileSize);
        Point br = dstTile.br();
        if (br.x >= (double)resultImage.cols()) {
            dstTile.width = (int)((double)dstTile.width - (br.x - (double)resultImage.cols()));
            srcTile.width = (int)((double)srcTile.width - (br.x - (double)resultImage.cols()));
        }
        if (br.y >= (double)resultImage.rows()) {
            dstTile.height = (int)((double)dstTile.height - (br.y - (double)resultImage.rows()));
            srcTile.height = (int)((double)srcTile.height - (br.y - (double)resultImage.rows()));
        }
        Mat tileView = tileOutput.submat(srcTile);
        Mat dstView = resultImage.submat(dstTile);
        assert (tileView.rows() == dstView.rows());
        assert (tileView.cols() == dstView.cols());
        tileView.copyTo(dstView);
    }

    private void processTileImpl(Mat tileInput, Mat tileOutput) {
    }

    private void copySourceTile(Mat sourceImage, Mat tileInput, Rect tile) {
        Point tl = tile.tl();
        Point br = tile.br();
        Point tloffset = new Point();
        Point broffset = new Point();
        if (tile.x < 0) {
            tloffset.x = -tile.x;
            tile.x = 0;
        }
        if (tile.y < 0) {
            tloffset.y = -tile.y;
            tile.y = 0;
        }
        if (br.x >= (double)sourceImage.cols()) {
            broffset.x = br.x - (double)sourceImage.cols() + 1.0;
            tile.width = (int)((double)tile.width - broffset.x);
        }
        if (br.y >= (double)sourceImage.rows()) {
            broffset.y = br.y - (double)sourceImage.rows() + 1.0;
            tile.height = (int)((double)tile.height - broffset.y);
        }
        if (tloffset.x > 0.0 || tloffset.y > 0.0 || broffset.x > 0.0 || broffset.y > 0.0) {
            Rect paddedTile = new Rect(tile.tl(), tile.br());
            assert (paddedTile.x >= 0);
            assert (paddedTile.y >= 0);
            assert (paddedTile.br().x < (double)sourceImage.cols());
            assert (paddedTile.br().y < (double)sourceImage.rows());
            Core.copyMakeBorder((Mat)sourceImage.submat(paddedTile), (Mat)tileInput, (int)((int)tloffset.y), (int)((int)broffset.y), (int)((int)tloffset.x), (int)((int)broffset.x), (int)this.mBorderType);
        } else {
            sourceImage.submat(tile).copyTo(tileInput);
        }
    }
}

