/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;

public class Pdf2Dcm {
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private static final long MAX_FILE_SIZE = 0x7FFFFFFEL;
    private static final int[] IUID_TAGS = new int[]{0x20000D, 0x20000E, 524312};
    private Attributes metadata;

    private static void supplementMissingUIDs(Attributes metadata) {
        for (int tag : IUID_TAGS) {
            if (metadata.containsValue(tag)) continue;
            metadata.setString(tag, VR.UI, UID.createUID());
        }
    }

    private static void supplementMissingDateTime(Attributes metadata, long tag, Date date) {
        if (!metadata.containsValue((int)(tag >>> 32))) {
            metadata.setDate(tag, date);
        }
    }

    private static void supplementMissingValue(Attributes metadata, int tag, String value) {
        if (!metadata.containsValue(tag)) {
            metadata.setString(tag, DICT.vrOf(tag), value);
        }
    }

    private void setMetadata(Attributes metadata) {
        this.metadata = metadata;
    }

    private void convert(File infile, File outfile) throws IOException {
        long fileLength = infile.length();
        if (fileLength > 0x7FFFFFFEL) {
            throw new IllegalArgumentException(infile.getName());
        }
        try (ImageOutputStream dos = new ImageOutputStream(outfile);){
            dos.writeDataset(this.metadata.createFileMetaInformation("1.2.840.10008.1.2.1"), this.metadata);
            dos.writeAttribute(4325393, VR.OB, Files.readAllBytes(infile.toPath()));
        }
    }
}

