/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class GitlabProvider
extends AbstractProvider {
    public GitlabProvider(Context context) {
        super(context, Registry.GITLAB);
    }

    public GitlabProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.GITLAB, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(callback.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).idToken(object.getString("id_token")).tokenType(object.getString("token_type")).scope(object.getString("scope")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(object.getString("username")).nickname(object.getString("name")).avatar(object.getString("avatar_url")).blog(object.getString("web_url")).company(object.getString("organization")).location(object.getString("location")).email(object.getString("email")).remark(object.getString("bio")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
        if (object.containsKey((Object)"message")) {
            throw new AuthorizedException(object.getString("message"));
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", "read_user+openid+profile+email").build();
    }
}

