/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.CellKit;
import org.aoju.bus.office.support.excel.ExcelBase;
import org.aoju.bus.office.support.excel.ExcelKit;
import org.aoju.bus.office.support.excel.ExcelWriter;
import org.aoju.bus.office.support.excel.RowKit;
import org.aoju.bus.office.support.excel.WorksKit;
import org.aoju.bus.office.support.excel.cell.CellEditor;
import org.aoju.bus.office.support.excel.cell.CellHandler;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;
    private Map<String, String> headerAlias = new HashMap<String, String>();

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileKit.file(excelFilePath), sheetIndex);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorksKit.createBook(bookFile), sheetIndex);
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorksKit.createBook(bookFile), sheetName);
    }

    public ExcelReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        this(WorksKit.createBook(bookStream, closeAfterRead), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        this(WorksKit.createBook(bookStream, closeAfterRead), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(book.getSheetAt(sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(book.getSheet(sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(sheet);
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    public ExcelReader setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelReader addHeaderAlias(String header, String alias) {
        this.headerAlias.put(header, alias);
        return this;
    }

    public ExcelReader removeHeaderAlias(String header) {
        this.headerAlias.remove(header);
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        boolean isFirstLine = true;
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = this.readRow(i);
            if (!CollKit.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            if (isFirstLine) {
                isFirstLine = false;
                if (MapKit.isNotEmpty(this.headerAlias)) {
                    rowList = this.aliasHeader(rowList);
                }
            }
            resultList.add(rowList);
        }
        return resultList;
    }

    public void read(CellHandler cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public void read(int startRowIndex, int endRowIndex, CellHandler cellHandler) {
        this.checkNotClosed();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = this.sheet.getRow(y);
            short columnSize = row.getLastCellNum();
            for (short x = 0; x < columnSize; x = (short)(x + 1)) {
                Cell cell = row.getCell((int)x);
                cellHandler.handle(cell, CellKit.getCellValue(cell));
            }
        }
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        int firstRowNum = this.sheet.getFirstRowNum();
        int lastRowNum = this.sheet.getLastRowNum();
        if (headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format("Header row index {} is lower than first row index {}.", headerRowIndex, firstRowNum));
        }
        if (headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format("Header row index {} is greater than last row index {}.", headerRowIndex, firstRowNum));
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        endRowIndex = Math.min(endRowIndex, lastRowNum);
        List<Object> headerList = this.readRow(this.sheet.getRow(headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == headerRowIndex || !CollKit.isNotEmpty(rowList = this.readRow(this.sheet.getRow(i))) && this.ignoreEmptyRow) continue;
            result.add(IterKit.toMap(this.aliasHeader(headerList), rowList, true));
        }
        return result;
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        this.checkNotClosed();
        List<Map<String, Object>> mapList = this.read(headerRowIndex, startRowIndex, endRowIndex);
        if (Map.class.isAssignableFrom(beanType)) {
            return mapList;
        }
        ArrayList<T> beanList = new ArrayList<T>(mapList.size());
        for (Map<String, Object> map : mapList) {
            beanList.add(BeanKit.mapToBean(map, beanType, false));
        }
        return beanList;
    }

    public String readAsText(boolean withSheetName) {
        ExcelExtractor extractor = this.getExtractor();
        extractor.setIncludeSheetNames(withSheetName);
        return extractor.getText();
    }

    public ExcelExtractor getExtractor() {
        Workbook wb = this.workbook;
        Object extractor = wb instanceof HSSFWorkbook ? new org.apache.poi.hssf.extractor.ExcelExtractor((HSSFWorkbook)wb) : new XSSFExcelExtractor((XSSFWorkbook)wb);
        return extractor;
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellKit.getCellValue(this.getCell(x, y), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        return new ExcelWriter(this.sheet);
    }

    private List<Object> readRow(Row row) {
        return RowKit.readRow(row, this.cellEditor);
    }

    private List<String> aliasHeader(List<Object> headerList) {
        int size = headerList.size();
        ArrayList<String> result = new ArrayList<String>(size);
        if (CollKit.isEmpty(headerList)) {
            return result;
        }
        for (int i = 0; i < size; ++i) {
            result.add(this.aliasHeader(headerList.get(i), i));
        }
        return result;
    }

    private String aliasHeader(Object headerObj, int index) {
        if (null == headerObj) {
            return ExcelKit.indexToColName(index);
        }
        String header = headerObj.toString();
        return ObjectKit.defaultIfNull(this.headerAlias.get(header), header);
    }

    private void checkNotClosed() {
        Assert.isFalse(this.isClosed, "ExcelReader has been closed!", new Object[0]);
    }
}

