/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.ServerConfig;
import org.aoju.bus.socket.origin.TcpAioSession;
import org.aoju.bus.socket.origin.TcpReadHandler;
import org.aoju.bus.socket.origin.TcpWriteHandler;
import org.aoju.bus.socket.origin.plugins.ssl.Handshake;
import org.aoju.bus.socket.origin.plugins.ssl.SSLService;

class SSLAioSession<T>
extends TcpAioSession<T> {
    private ByteBuffer netWriteBuffer;
    private ByteBuffer netReadBuffer;
    private SSLEngine sslEngine = null;
    private Handshake handshakeModel;
    private SSLService sslService;

    SSLAioSession(AsynchronousSocketChannel channel, ServerConfig<T> config, TcpReadHandler<T> aioReadCompletionHandler, TcpWriteHandler<T> aioWriteCompletionHandler, SSLService sslService, PageBuffer pageBuffer) {
        super(channel, config, aioReadCompletionHandler, aioWriteCompletionHandler, pageBuffer);
        this.handshakeModel = sslService.createSSLEngine(channel);
        this.sslService = sslService;
    }

    @Override
    void writeToChannel() {
        this.checkInitialized();
        if (this.netWriteBuffer != null && this.netWriteBuffer.hasRemaining()) {
            this.writeToChannel0(this.netWriteBuffer);
            return;
        }
        super.writeToChannel();
    }

    @Override
    void initSession() {
        this.sslEngine = this.handshakeModel.getSslEngine();
        this.netWriteBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.netWriteBuffer.flip();
        this.netReadBuffer = ByteBuffer.allocate(this.readBuffer.buffer().capacity());
        this.handshakeModel.setHandshakeCallback(() -> {
            SSLAioSession sSLAioSession = this;
            synchronized (sSLAioSession) {
                this.handshakeModel = null;
                this.notifyAll();
            }
            this.sslService = null;
            this.continueRead();
        });
        this.sslService.doHandshake(this.handshakeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        if (this.handshakeModel == null) {
            return;
        }
        SSLAioSession sSLAioSession = this;
        synchronized (sSLAioSession) {
            if (this.handshakeModel == null) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.debug(e.getMessage(), e);
            }
        }
    }

    @Override
    void readFromChannel(boolean eof) {
        this.checkInitialized();
        this.doUnWrap();
        super.readFromChannel(eof);
    }

    @Override
    protected void continueRead() {
        this.readFromChannel0(this.netReadBuffer);
    }

    @Override
    protected void continueWrite(VirtualBuffer writeBuffer) {
        this.doWrap(writeBuffer);
        this.writeToChannel0(this.netWriteBuffer);
    }

    private void doWrap(VirtualBuffer writeBuffer) {
        try {
            this.netWriteBuffer.compact();
            SSLEngineResult result = this.sslEngine.wrap(writeBuffer.buffer(), this.netWriteBuffer);
            while (result.getStatus() != SSLEngineResult.Status.OK) {
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        Logger.info("doWrap BUFFER_OVERFLOW", new Object[0]);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        Logger.info("doWrap BUFFER_UNDERFLOW", new Object[0]);
                        break;
                    }
                    default: {
                        Logger.error("doWrap Result:" + (Object)((Object)result.getStatus()), new Object[0]);
                    }
                }
                result = this.sslEngine.wrap(writeBuffer.buffer(), this.netWriteBuffer);
            }
            this.netWriteBuffer.flip();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private void doUnWrap() {
        try {
            this.netReadBuffer.flip();
            ByteBuffer readBuffer = this.readBuffer.buffer();
            SSLEngineResult result = this.sslEngine.unwrap(this.netReadBuffer, readBuffer);
            boolean closed = false;
            while (!closed && result.getStatus() != SSLEngineResult.Status.OK) {
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        int appSize = readBuffer.capacity() * 2 < this.sslEngine.getSession().getApplicationBufferSize() ? readBuffer.capacity() * 2 : this.sslEngine.getSession().getApplicationBufferSize();
                        Logger.info("doUnWrap BUFFER_OVERFLOW:" + appSize, new Object[0]);
                        ByteBuffer b = ByteBuffer.allocate(appSize + readBuffer.position());
                        readBuffer.flip();
                        b.put(readBuffer);
                        readBuffer = b;
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        if (this.netReadBuffer.limit() == this.netReadBuffer.capacity()) {
                            int netSize = this.netReadBuffer.capacity() * 2 < this.sslEngine.getSession().getPacketBufferSize() ? this.netReadBuffer.capacity() * 2 : this.sslEngine.getSession().getPacketBufferSize();
                            Logger.debug("BUFFER_UNDERFLOW:" + netSize, new Object[0]);
                            ByteBuffer b1 = ByteBuffer.allocate(netSize);
                            b1.put(this.netReadBuffer);
                            this.netReadBuffer = b1;
                        } else {
                            if (this.netReadBuffer.position() > 0) {
                                this.netReadBuffer.compact();
                            } else {
                                this.netReadBuffer.position(this.netReadBuffer.limit());
                                this.netReadBuffer.limit(this.netReadBuffer.capacity());
                            }
                            Logger.debug("BUFFER_UNDERFLOW,continue read:" + this.netReadBuffer, new Object[0]);
                        }
                        return;
                    }
                    case CLOSED: {
                        Logger.debug("doUnWrap Result:" + (Object)((Object)result.getStatus()), new Object[0]);
                        closed = true;
                        break;
                    }
                    default: {
                        Logger.error("doUnWrap Result:" + (Object)((Object)result.getStatus()), new Object[0]);
                    }
                }
                result = this.sslEngine.unwrap(this.netReadBuffer, readBuffer);
            }
            this.netReadBuffer.compact();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(boolean immediate) {
        super.close(immediate);
        if (this.status == 1) {
            this.sslEngine.closeOutbound();
        }
    }
}

