/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.validators;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.exception.NoSuchException;
import org.aoju.bus.core.lang.exception.ValidateException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.validate.Collector;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.Provider;
import org.aoju.bus.validate.Registry;
import org.aoju.bus.validate.Validated;
import org.aoju.bus.validate.annotation.Inside;
import org.aoju.bus.validate.validators.Matcher;
import org.aoju.bus.validate.validators.Property;

public class Checker {
    public Collector object(Validated validated, Property property) throws ValidateException {
        Collector collector = new Collector(validated);
        Context context = validated.getContext();
        if (Provider.isGroup(property.getGroup(), context.getGroup())) {
            collector.collect(this.doObject(validated, property));
        }
        List<Property> list = property.getList();
        for (Property p : list) {
            collector.collect(this.doObject(validated, p));
        }
        return collector;
    }

    public Collector inside(Validated validated) {
        Collector collector = new Collector(validated);
        try {
            Object object = validated.getObject();
            if (ObjectKit.isNotEmpty(object)) {
                Field[] fields;
                for (Field field : fields = ClassKit.getAllFields(object.getClass())) {
                    String[] xSkip;
                    Object value = ClassKit.readField(field, object, true);
                    Annotation[] annotations = field.getDeclaredAnnotations();
                    String[] xFields = validated.getContext().getField();
                    String[] stringArray = xSkip = validated.getContext().getSkip() == null ? null : validated.getContext().getSkip();
                    if (ArrayKit.isNotEmpty(xSkip) && Arrays.asList(xSkip).contains(field.getName()) || ArrayKit.isNotEmpty(xFields) && !Arrays.asList(xFields).contains(field.getName())) continue;
                    validated.getContext().setInside(false);
                    validated = new Validated(value, annotations, validated.getContext(), field.getName());
                    if (value != null && Provider.isCollection(value) && this.hasInside(annotations)) {
                        collector.collect(this.doCollectionInside(validated));
                    } else if (value != null && Provider.isArray(value) && this.hasInside(annotations)) {
                        collector.collect(this.doArrayInside(validated));
                    }
                    if (validated.getList().isEmpty()) continue;
                    collector.collect(validated.access());
                }
            } else {
                Logger.debug("\u5f53\u524d\u88ab\u6821\u9a8c\u7684\u5bf9\u8c61\u4e3anull, \u5ffd\u7565\u6821\u9a8c\u5bf9\u8c61\u5185\u90e8\u5b57\u6bb5: {}", validated);
            }
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("\u65e0\u6cd5\u6821\u9a8c\u6307\u5b9a\u5b57\u6bb5", e);
        }
        return collector;
    }

    private Collector doObject(Validated validated, Property property) {
        Matcher matcher = (Matcher)Registry.getInstance().require(property.getName(), property.getClazz());
        if (ObjectKit.isEmpty((Object)matcher)) {
            throw new NoSuchException(String.format("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u7684\u6821\u9a8c\u5668, name:%s, class:%s", property.getName(), property.getClazz() == null ? "null" : property.getClazz().getName()));
        }
        Object validatedTarget = validated.getObject();
        if (ObjectKit.isNotEmpty(validatedTarget) && property.isArray() && Provider.isArray(validatedTarget)) {
            return this.doArrayObject(validated, property);
        }
        if (ObjectKit.isNotEmpty(validatedTarget) && property.isArray() && Provider.isCollection(validatedTarget)) {
            return this.doCollection(validated, property);
        }
        boolean result = matcher.on(validatedTarget, property.getAnnotation(), validated.getContext());
        if (!result && validated.getContext().isFast()) {
            throw Provider.resolve(property, validated.getContext());
        }
        return new Collector(validated, property, result);
    }

    private Collector doCollection(Validated validated, Property property) {
        Collector collector = new Collector(validated);
        Collection collection = (Collection)validated.getObject();
        for (Object item : collection) {
            Validated itemTarget = new Validated(item, new Annotation[]{property.getAnnotation()}, validated.getContext());
            Collector checked = itemTarget.access();
            collector.collect(checked);
        }
        return collector;
    }

    private Collector doArrayObject(Validated validated, Property property) {
        Collector collector = new Collector(validated);
        Object[] array = (Object[])validated.getObject();
        for (int i = 0; i < array.length; ++i) {
            Validated itemTarget = new Validated(array[i], new Annotation[]{property.getAnnotation()}, validated.getContext());
            Collector checked = itemTarget.access();
            collector.collect(checked);
        }
        return collector;
    }

    private Collector doArrayInside(Validated validated) {
        Object[] array;
        Collector collector = new Collector(validated);
        for (Object object : array = (Object[])validated.getObject()) {
            collector.collect(this.inside(new Validated(object, validated.getContext())));
        }
        return collector;
    }

    private Collector doCollectionInside(Validated validated) {
        Collector collector = new Collector(validated);
        Collection collection = (Collection)validated.getObject();
        for (Object item : collection) {
            collector.collect(this.inside(new Validated(item, validated.getContext())));
        }
        return collector;
    }

    private boolean hasInside(Annotation[] annotations) {
        return Arrays.stream(annotations).anyMatch(an -> an instanceof Inside);
    }
}

