/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.util.Map;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.StringKit;

public abstract class AbstractConverter<T>
implements Converter<T> {
    @Override
    public T convert(Object value, T defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(StringKit.format("[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            T result;
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            try {
                result = this.convertInternal(value);
            }
            catch (RuntimeException e) {
                return defaultValue;
            }
            return null == result ? defaultValue : result;
        }
        throw new IllegalArgumentException(StringKit.format("Default value [{}]({}) is not the instance of [{}]", defaultValue, defaultValue.getClass(), targetType));
    }

    public T convertQuietly(Object value, T defaultValue) {
        try {
            return this.convert(value, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayKit.isArray(value)) {
            return ArrayKit.toString(value);
        }
        if (CharKit.isChar(value)) {
            return CharKit.toString(((Character)value).charValue());
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassKit.getTypeArgument(this.getClass());
    }
}

