/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.software;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.unix.aix.software.AixOSFileStore;

@ThreadSafe
public class AixFileSystem
extends AbstractFileSystem {
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/proc");

    static List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        return AixFileSystem.getFileStoreMatching(nameToMatch, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, boolean localOnly) {
        String[] split;
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        String command = "df -i" + (localOnly ? " -l" : "");
        for (String line : Executor.runNative(command)) {
            if (!line.startsWith("/") || (split = RegEx.SPACES.split(line)).length <= 5) continue;
            inodeTotalMap.put(split[0], Builder.parseLongOrDefault(split[1], 0L));
            inodeFreeMap.put(split[0], Builder.parseLongOrDefault(split[3], 0L));
        }
        for (String fs : Executor.runNative("mount")) {
            split = RegEx.SPACES.split("x" + fs);
            if (split.length <= 7) continue;
            String volume = split[1];
            String path = split[2];
            String type = split[3];
            String options = split[4];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || PSEUDO_FS_TYPES.contains(type) || path.equals("/dev") || !path.startsWith("/") || Builder.filePathStartsWith(TMP_FS_PATHS, path) && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            fsList.add(new AixOSFileStore(name, volume, name, path, options, "", "", description, type, freeSpace, usableSpace, totalSpace, inodeFreeMap.getOrDefault(volume, 0L), inodeTotalMap.getOrDefault(volume, 0L)));
        }
        return fsList;
    }

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        return AixFileSystem.getFileStoreMatching(null, localOnly);
    }

    @Override
    public long getOpenFileDescriptors() {
        boolean header = false;
        long openfiles = 0L;
        for (String f : Executor.runNative("lsof -nl")) {
            if (!header) {
                header = f.startsWith("COMMAND");
                continue;
            }
            ++openfiles;
        }
        return openfiles;
    }

    @Override
    public long getMaxFileDescriptors() {
        return Builder.parseLongOrDefault(Executor.getFirstAnswer("ulimit -n"), 0L);
    }
}

