/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quintet;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.Win32Bios;

@Immutable
final class WindowsFirmware
extends AbstractFirmware {
    private final Supplier<Quintet<String, String, String, String, String>> manufNameDescVersRelease = Memoize.memoize(WindowsFirmware::queryManufNameDescVersRelease);

    WindowsFirmware() {
    }

    private static Quintet<String, String, String, String, String> queryManufNameDescVersRelease() {
        String manufacturer = null;
        String name = null;
        String description = null;
        String version = null;
        String releaseDate = null;
        WbemcliUtil.WmiResult<Win32Bios.BiosProperty> win32BIOS = Win32Bios.queryBiosInfo();
        if (win32BIOS.getResultCount() > 0) {
            manufacturer = WmiKit.getString(win32BIOS, Win32Bios.BiosProperty.MANUFACTURER, 0);
            name = WmiKit.getString(win32BIOS, Win32Bios.BiosProperty.NAME, 0);
            description = WmiKit.getString(win32BIOS, Win32Bios.BiosProperty.DESCRIPTION, 0);
            version = WmiKit.getString(win32BIOS, Win32Bios.BiosProperty.VERSION, 0);
            releaseDate = WmiKit.getDateString(win32BIOS, Win32Bios.BiosProperty.RELEASEDATE, 0);
        }
        return new Quintet<String, String, String, String, String>(StringKit.isBlank(manufacturer) ? "unknown" : manufacturer, StringKit.isBlank(name) ? "unknown" : name, StringKit.isBlank(description) ? "unknown" : description, StringKit.isBlank(version) ? "unknown" : version, StringKit.isBlank(releaseDate) ? "unknown" : releaseDate);
    }

    @Override
    public String getManufacturer() {
        return this.manufNameDescVersRelease.get().getA();
    }

    @Override
    public String getName() {
        return this.manufNameDescVersRelease.get().getB();
    }

    @Override
    public String getDescription() {
        return this.manufNameDescVersRelease.get().getC();
    }

    @Override
    public String getVersion() {
        return this.manufNameDescVersRelease.get().getD();
    }

    @Override
    public String getReleaseDate() {
        return this.manufNameDescVersRelease.get().getE();
    }
}

