/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class MicrosoftProvider
extends AbstractProvider {
    public MicrosoftProvider(Context context) {
        super(context, Registry.MICROSOFT);
    }

    public MicrosoftProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.MICROSOFT, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    private AccToken getToken(String accessTokenUrl) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "https://login.microsoftonline.com");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UriKit.decodeVal(accessTokenUrl, "UTF-8").forEach(paramMap::put);
        String response = Httpx.post(accessTokenUrl, paramMap, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).scope(object.getString("scope")).tokenType(object.getString("token_type")).refreshToken(object.getString("refresh_token")).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String token = accToken.getAccessToken();
        String tokenType = accToken.getTokenType();
        String jwt = tokenType + " " + token;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", jwt);
        String response = Httpx.get(this.userInfoUrl(accToken), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(object.getString("userPrincipalName")).nickname(object.getString("displayName")).location(object.getString("officeLocation")).email(object.getString("mail")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(accToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("response_mode", "query").queryParam("scope", this.getScopes(" ", true, MicrosoftProvider.getScopes(true, OauthScope.Microsoft.values()))).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("scope", "user.read%20mail.read").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).build();
    }

    @Override
    public String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.source.refresh()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("scope", "user.read%20mail.read").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }
}

