/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.CellKit;
import org.aoju.bus.office.support.excel.StyleSet;
import org.aoju.bus.office.support.excel.cell.CellEditor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class RowKit {
    public static Row getOrCreateRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        return RowKit.readRow(row, 0, Short.MAX_VALUE, cellEditor);
    }

    public static List<Object> readRow(Row row, int startCellNumInclude, int endCellNumInclude, CellEditor cellEditor) {
        if (null == row) {
            return new ArrayList<Object>(0);
        }
        short rowLength = row.getLastCellNum();
        if (rowLength < 0) {
            return Collections.emptyList();
        }
        int size = Math.min(endCellNumInclude + 1, rowLength);
        ArrayList<Object> cellValues = new ArrayList<Object>(size);
        boolean isAllNull = true;
        for (int i = startCellNumInclude; i < size; ++i) {
            Object cellValue = CellKit.getCellValue(row.getCell(i), cellEditor);
            isAllNull &= StringKit.emptyIfStr(cellValue);
            cellValues.add(cellValue);
        }
        if (isAllNull) {
            return Collections.emptyList();
        }
        return cellValues;
    }

    public static void writeRow(Row row, Iterable<?> rowData, StyleSet styleSet, boolean isHeader) {
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            CellKit.setCellValue(cell, value, styleSet, isHeader);
            ++i;
        }
    }
}

