/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.core.beans.copier;

import java.lang.reflect.Type;

/**
 * 值提供者,用于提供Bean注入时参数对应值得抽象接口
 * 继承或匿名实例化此接口
 * 在Bean注入过程中,Bean获得字段名,
 * 通过外部方式根据这个字段名查找相应的字段值,然后注入Bean
 *
 * @param <T> KEY类型,一般情况下为 {@link String}
 * @author Kimi Liu
 * @version 6.0.9
 * @since JDK 1.8+
 */
public interface ValueProvider<T> {

    /**
     * 获取值
     *
     * @param key       Bean对象中参数名
     * @param valueType 被注入的值的类型
     * @return 对应参数名的值
     */
    Object value(T key, Type valueType);

    /**
     * 是否包含指定KEY,如果不包含则忽略注入
     * 此接口方法单独需要实现的意义在于：
     * 有些值提供者比如(Map)key是存在的,
     * 但是value为null,此时如果需要注入null,
     * 需要根据此方法判断
     *
     * @param key Bean对象中参数名
     * @return 是否包含指定KEY
     */
    boolean containsKey(T key);

}
