/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.core.lang.caller;

import org.aoju.bus.core.toolkit.CallerKit;

/**
 * 调用者接口
 * 可以通过此接口的实现类方法获取调用者、多级调用者以及判断是否被调用
 *
 * @author Kimi Liu
 * @version 6.0.9
 * @since JDK 1.8+
 */
public interface Caller {

    /**
     * 获得调用者
     *
     * @return 调用者
     */
    Class<?> getCaller();

    /**
     * 获得调用者的调用者
     *
     * @return 调用者的调用者
     */
    Class<?> getCallers();

    /**
     * 获得调用者,指定第几级调用者 调用者层级关系：
     *
     * <pre>
     * 0 {@link CallerKit}
     * 1 调用{@link CallerKit}中方法的类
     * 2 调用者的调用者
     * ...
     * </pre>
     *
     * @param depth 层级 0表示{@link CallerKit}本身,1表示调用{@link CallerKit}的类,2表示调用者的调用者,依次类推
     * @return 第几级调用者
     */
    Class<?> getCaller(int depth);

    /**
     * 是否被指定类调用
     *
     * @param clazz 调用者类
     * @return 是否被调用
     */
    boolean isCalledBy(Class<?> clazz);

}
