/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;

public class DateConverter
extends AbstractConverter<Date> {
    private final Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        Long mills = null;
        if (value instanceof Calendar) {
            mills = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Number) {
            mills = ((Number)value).longValue();
        } else {
            if (value instanceof TemporalAccessor) {
                return DateKit.date((TemporalAccessor)value);
            }
            String valueStr = this.convertString(value);
            Date date = null;
            try {
                date = StringKit.isBlank(this.format) ? DateKit.parse(valueStr) : DateKit.parse(valueStr, this.format);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != date) {
                mills = date.getTime();
            }
        }
        if (null == mills) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return new DateTime(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StringKit.format("Unsupport Date type: {}", this.targetType.getName()));
    }
}

