/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ImageKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Image
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedImage srcImage;
    private java.awt.Image targetImage;
    private String targetImageType = "jpg";
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;

    public Image(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public Image(BufferedImage srcImage, String imageType) {
        this.srcImage = srcImage;
        if (null == this.targetImageType) {
            this.targetImageType = srcImage.getType() == 2 || srcImage.getType() == 3 || srcImage.getType() == 6 || srcImage.getType() == 7 ? "png" : "jpg";
        }
        this.targetImageType = imageType;
    }

    public static Image from(Path imagePath) {
        return Image.from(imagePath.toFile());
    }

    public static Image from(File imageFile) {
        return new Image(ImageKit.read(imageFile));
    }

    public static Image from(Resource resource) {
        return Image.from(resource.getStream());
    }

    public static Image from(InputStream in) {
        return new Image(ImageKit.read(in));
    }

    public static Image from(ImageInputStream imageStream) {
        return new Image(ImageKit.read(imageStream));
    }

    public static Image from(URL imageUrl) {
        return new Image(ImageKit.read(imageUrl));
    }

    public static Image from(java.awt.Image image) {
        return new Image(ImageKit.toBufferedImage(image));
    }

    private static BufferedImage draw(BufferedImage backgroundImg, java.awt.Image image, Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        g.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        g.dispose();
        return backgroundImg;
    }

    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        double r = Math.sqrt(height * height + width * width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angel_dalta_width = Math.atan((double)height / (double)width);
        double angel_dalta_height = Math.atan((double)width / (double)height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = width + len_dalta_width * 2;
        int des_height = height + len_dalta_height * 2;
        return new Rectangle(des_width, des_height);
    }

    public Image setTargetImageType(String imgType) {
        this.targetImageType = imgType;
        return this;
    }

    public Image setPositionBaseCentre(boolean positionBaseCentre) {
        this.positionBaseCentre = positionBaseCentre;
        return this;
    }

    public Image setQuality(double quality) {
        return this.setQuality((float)quality);
    }

    public Image setQuality(float quality) {
        this.quality = quality > 0.0f && quality < 1.0f ? quality : 1.0f;
        return this;
    }

    public Image scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        java.awt.Image srcImage = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), null);
            this.targetImage = op.filter(ImageKit.toBufferedImage(srcImage), null);
        } else {
            String scaleStr = Float.toString(scale);
            int width = MathKit.mul(Integer.toString(srcImage.getWidth(null)), scaleStr).intValue();
            int height = MathKit.mul(Integer.toString(srcImage.getHeight(null)), scaleStr).intValue();
            this.scale(width, height);
        }
        return this;
    }

    public Image scale(int width, int height) {
        java.awt.Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImage;
            return this;
        }
        int scaleType = srcHeight < height || srcWidth < width ? 4 : 1;
        double sx = MathKit.div((float)width, (float)srcWidth);
        double sy = MathKit.div((float)height, (float)srcHeight);
        if ("png".equals(this.targetImageType)) {
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(sx, sy), null);
            this.targetImage = op.filter(ImageKit.toBufferedImage(srcImage), null);
        } else {
            this.targetImage = srcImage.getScaledInstance(width, height, scaleType);
        }
        return this;
    }

    public Image scale(int width, int height, Color fixedColor) {
        java.awt.Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = MathKit.div((float)height, (float)srcHeight);
        double widthRatio = MathKit.div((float)width, (float)srcWidth);
        if (widthRatio == heightRatio) {
            this.scale(width, height);
        } else if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        srcImage = this.getValidSrcImg();
        srcHeight = srcImage.getHeight(null);
        srcWidth = srcImage.getWidth(null);
        if (null == fixedColor) {
            fixedColor = Color.WHITE;
        }
        BufferedImage image = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D g = image.createGraphics();
        g.setBackground(fixedColor);
        g.clearRect(0, 0, width, height);
        g.drawImage(srcImage, (width - srcWidth) / 2, (height - srcHeight) / 2, srcWidth, srcHeight, fixedColor, null);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public Image cut(Rectangle rectangle) {
        java.awt.Image srcImage = this.getValidSrcImg();
        rectangle = this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        java.awt.Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(srcImage.getSource(), cropFilter));
        this.targetImage = ImageKit.toBufferedImage(image);
        return this;
    }

    public Image cut(int x, int y) {
        return this.cut(x, y, -1);
    }

    public Image cut(int x, int y, int radius) {
        java.awt.Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        int diameter = radius > 0 ? radius * 2 : Math.min(width, height);
        BufferedImage targetImage = new BufferedImage(diameter, diameter, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setClip(new Ellipse2D.Double(0.0, 0.0, diameter, diameter));
        if (this.positionBaseCentre) {
            x = x - width / 2 + diameter / 2;
            y = y - height / 2 + diameter / 2;
        }
        g.drawImage(srcImage, x, y, null);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Image round(double arc) {
        java.awt.Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        arc = MathKit.mul(arc, (float)Math.min(width, height));
        BufferedImage targetImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = targetImage.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(srcImage, 0, 0, null);
        g2.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Image gray() {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.targetImage = op.filter(ImageKit.toBufferedImage(this.getValidSrcImg()), null);
        return this;
    }

    public Image binary() {
        this.targetImage = ImageKit.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    public Image pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage targetImage = ImageKit.toBufferedImage(this.getValidSrcImg());
        Graphics2D g = targetImage.createGraphics();
        if (null == font) {
            font = new Font("Courier", 0, (int)((double)targetImage.getHeight() * 0.75));
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(color);
        g.setFont(font);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        FontMetrics metrics = g.getFontMetrics(font);
        int textLength = metrics.stringWidth(pressText);
        int textHeight = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        g.drawString(pressText, Math.abs(targetImage.getWidth() - textLength) / 2 + x, Math.abs(targetImage.getHeight() + textHeight) / 2 + y);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Image pressImage(java.awt.Image pressImage, int x, int y, float alpha) {
        int pressImgWidth = pressImage.getWidth(null);
        int pressImgHeight = pressImage.getHeight(null);
        return this.pressImage(pressImage, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public Image pressImage(java.awt.Image pressImage, Rectangle rectangle, float alpha) {
        java.awt.Image targetImage = this.getValidSrcImg();
        this.targetImage = Image.draw(ImageKit.toBufferedImage(targetImage, this.targetImageType), pressImage, rectangle, alpha);
        return this;
    }

    public Image rotate(int degree) {
        java.awt.Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = Image.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.translate((rectangle.width - width) / 2, (rectangle.height - height) / 2);
        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Image flip() {
        java.awt.Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public java.awt.Image getImg() {
        return null == this.targetImage ? this.srcImage : this.targetImage;
    }

    public boolean write(OutputStream out) throws InstrumentException {
        return this.write(ImageKit.getImageOutputStream(out));
    }

    public boolean write(ImageOutputStream targetImageStream) throws InstrumentException {
        Assert.notBlank(this.targetImageType, "Target image type is blank !", new Object[0]);
        Assert.notNull(targetImageStream, "Target output stream is null !", new Object[0]);
        java.awt.Image targetImage = null == this.targetImage ? this.srcImage : this.targetImage;
        Assert.notNull(targetImage, "Target image is null !", new Object[0]);
        return ImageKit.write(targetImage, this.targetImageType, targetImageStream, this.quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File targetFile) throws InstrumentException {
        String formatName = FileKit.extName(targetFile);
        if (StringKit.isNotBlank(formatName)) {
            this.targetImageType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ImageOutputStream out = null;
        try {
            out = ImageKit.getImageOutputStream(targetFile);
            boolean bl = this.write(out);
            return bl;
        }
        finally {
            IoKit.close(out);
        }
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private java.awt.Image getValidSrcImg() {
        return ObjectKit.defaultIfNull(this.targetImage, this.srcImage);
    }

    private Rectangle fixRectangle(Rectangle rectangle, int baseWidth, int baseHeight) {
        if (this.positionBaseCentre) {
            rectangle.setLocation(rectangle.x + Math.abs(baseWidth - rectangle.width) / 2, rectangle.y + Math.abs(baseHeight - rectangle.height) / 2);
        }
        return rectangle;
    }

    public Image stroke(Color color, float width) {
        return this.stroke(color, new BasicStroke(width));
    }

    public Image stroke(Color color, Stroke stroke) {
        BufferedImage image = ImageKit.toBufferedImage(this.getValidSrcImg());
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Graphics2D g = image.createGraphics();
        g.setColor(ObjectKit.defaultIfNull(color, Color.BLACK));
        if (null != stroke) {
            g.setStroke(stroke);
        }
        g.drawRect(0, 0, width - 1, height - 1);
        g.dispose();
        this.targetImage = image;
        return this;
    }
}

