/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha.provider;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.image.Graphics;
import org.aoju.bus.core.toolkit.ImageKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.extra.captcha.provider.AbstractProvider;

public class LineProvider
extends AbstractProvider {
    public LineProvider(int width, int height) {
        this(width, height, 5, 150);
    }

    public LineProvider(int width, int height, int codeCount, int lineCount) {
        super(width, height, codeCount, lineCount);
    }

    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = Graphics.createGraphics(image, ObjectKit.defaultIfNull(this.background, Color.WHITE));
        this.drawInterfere(g);
        this.drawString(g, code);
        return image;
    }

    private void drawString(Graphics2D g, String code) {
        if (null != this.textAlpha) {
            g.setComposite(this.textAlpha);
        }
        Graphics.drawStringColourful(g, code, this.font, this.width, this.height);
    }

    private void drawInterfere(Graphics2D g) {
        ThreadLocalRandom random = RandomKit.getRandom();
        for (int i = 0; i < this.interfereCount; ++i) {
            int xs = random.nextInt(this.width);
            int ys = random.nextInt(this.height);
            int xe = xs + random.nextInt(this.width / 8);
            int ye = ys + random.nextInt(this.height / 8);
            g.setColor(ImageKit.randomColor(random));
            g.drawLine(xs, ys, xe, ye);
        }
    }
}

