/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.forest.archive;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.forest.Complex;
import org.aoju.bus.forest.algorithm.Key;
import org.aoju.bus.forest.provider.DecryptorProvider;
import org.aoju.bus.forest.provider.EntryDecryptorProvider;

public class DirDecryptorProvider
extends EntryDecryptorProvider<File>
implements DecryptorProvider {
    public DirDecryptorProvider(DecryptorProvider xEncryptor) {
        this(xEncryptor, (Complex<File>)null);
    }

    public DirDecryptorProvider(DecryptorProvider decryptorProvider, Complex<File> filter) {
        super(decryptorProvider, filter);
    }

    @Override
    public void decrypt(Key key, File src, File dest) throws IOException {
        if (src.isFile()) {
            DecryptorProvider decryptor = this.on(src) ? this.decryptorProvider : this.xNopDecryptor;
            decryptor.decrypt(key, src, dest);
        } else if (src.isDirectory()) {
            File[] files = src.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                this.decrypt(key, files[i], new File(dest, files[i].getName()));
            }
        }
    }
}

