/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.HardwareAbstractionLayer;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.linux.hardware.LinuxHardwareAbstractionLayer;
import org.aoju.bus.health.linux.software.LinuxOperatingSystem;
import org.aoju.bus.health.mac.hardware.MacHardwareAbstractionLayer;
import org.aoju.bus.health.mac.software.MacOperatingSystem;
import org.aoju.bus.health.unix.aix.hardware.AixHardwareAbstractionLayer;
import org.aoju.bus.health.unix.aix.software.AixOperatingSystem;
import org.aoju.bus.health.unix.freebsd.hardware.FreeBsdHardwareAbstractionLayer;
import org.aoju.bus.health.unix.freebsd.software.FreeBsdOperatingSystem;
import org.aoju.bus.health.unix.solaris.hardware.SolarisHardwareAbstractionLayer;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;
import org.aoju.bus.health.windows.hardware.WindowsHardwareAbstractionLayer;
import org.aoju.bus.health.windows.software.WindowsOperatingSystem;

public class Platform {
    private static final OS OS_CURRENT_PLATFORM = com.sun.jna.Platform.isWindows() ? OS.WINDOWS : (com.sun.jna.Platform.isLinux() ? OS.LINUX : (com.sun.jna.Platform.isMac() ? OS.MACOSX : (com.sun.jna.Platform.isSolaris() ? OS.SOLARIS : (com.sun.jna.Platform.isFreeBSD() ? OS.FREEBSD : (com.sun.jna.Platform.isAIX() ? OS.AIX : OS.UNKNOWN)))));
    private final Supplier<OperatingSystem> os = Memoize.memoize(this::createOperatingSystem);
    private final Supplier<HardwareAbstractionLayer> hardware = Memoize.memoize(this::createHardware);

    public static OS getCurrentPlatform() {
        return OS_CURRENT_PLATFORM;
    }

    public static OS getCurrentOs() {
        return OS_CURRENT_PLATFORM;
    }

    public static int getOSType() {
        return com.sun.jna.Platform.getOSType();
    }

    public static boolean isMac() {
        return com.sun.jna.Platform.isMac();
    }

    public static boolean isAndroid() {
        return com.sun.jna.Platform.isAndroid();
    }

    public static boolean isLinux() {
        return com.sun.jna.Platform.isLinux();
    }

    public static boolean isAIX() {
        return com.sun.jna.Platform.isAIX();
    }

    public static boolean isWindowsCE() {
        return com.sun.jna.Platform.isWindowsCE();
    }

    public static boolean isWindows() {
        return com.sun.jna.Platform.isWindows();
    }

    public static boolean isSolaris() {
        return com.sun.jna.Platform.isSolaris();
    }

    public static boolean isFreeBSD() {
        return com.sun.jna.Platform.isFreeBSD();
    }

    public static boolean isOpenBSD() {
        return com.sun.jna.Platform.isOpenBSD();
    }

    public static boolean isNetBSD() {
        return com.sun.jna.Platform.isNetBSD();
    }

    public static boolean isGNU() {
        return com.sun.jna.Platform.isGNU();
    }

    public static boolean iskFreeBSD() {
        return com.sun.jna.Platform.iskFreeBSD();
    }

    public static boolean isX11() {
        return com.sun.jna.Platform.isX11();
    }

    public static boolean hasRuntimeExec() {
        return com.sun.jna.Platform.hasRuntimeExec();
    }

    public static boolean is64Bit() {
        return com.sun.jna.Platform.is64Bit();
    }

    public static boolean isIntel() {
        return com.sun.jna.Platform.isIntel();
    }

    public static boolean isPPC() {
        return com.sun.jna.Platform.isPPC();
    }

    public static boolean isARM() {
        return com.sun.jna.Platform.isARM();
    }

    public static boolean isSPARC() {
        return com.sun.jna.Platform.isSPARC();
    }

    public static boolean isMIPS() {
        return com.sun.jna.Platform.isMIPS();
    }

    public static String getNativeLibraryResourcePrefix() {
        return Platform.getNativeLibraryResourcePrefix(Platform.getOSType(), System.getProperty("os.arch"), System.getProperty("os.name"));
    }

    public static String getNativeLibraryResourcePrefix(int osType, String arch, String name) {
        String osPrefix;
        if ("powerpc".equals(arch = arch.toLowerCase().trim())) {
            arch = "ppc";
        } else if ("powerpc64".equals(arch)) {
            arch = "ppc64";
        } else if ("i386".equals(arch)) {
            arch = "x86";
        } else if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            arch = "x86-64";
        }
        switch (osType) {
            case 8: {
                if (arch.startsWith("arm")) {
                    arch = "arm";
                }
                osPrefix = "android-" + arch;
                break;
            }
            case 2: {
                osPrefix = "win32-" + arch;
                break;
            }
            case 6: {
                osPrefix = "w32ce-" + arch;
                break;
            }
            case 0: {
                osPrefix = "macosx-" + arch;
                break;
            }
            case 1: {
                osPrefix = "linux-" + arch;
                break;
            }
            case 3: {
                osPrefix = "sunos-" + arch;
                break;
            }
            case 4: {
                osPrefix = "freebsd-" + arch;
                break;
            }
            case 5: {
                osPrefix = "openbsd-" + arch;
                break;
            }
            case 11: {
                osPrefix = "netbsd-" + arch;
                break;
            }
            case 10: {
                osPrefix = "kfreebsd-" + arch;
                break;
            }
            case 7: {
                osPrefix = "aix-" + arch;
                break;
            }
            default: {
                osPrefix = name.toLowerCase();
                int space = osPrefix.indexOf(" ");
                if (space != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = osPrefix + "-" + arch;
            }
        }
        return osPrefix;
    }

    public static String get(String name, String defaultValue) {
        return StringKit.nullToDefault(Platform.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            throw new InstrumentException(e);
        }
    }

    public static String get(String key) {
        return Platform.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = Platform.get(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    public static long getInt(String key, int defaultValue) {
        return Convert.toInt(Platform.get(key), defaultValue).intValue();
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(Platform.get(key), defaultValue);
    }

    public static Properties props() {
        return System.getProperties();
    }

    public static long getCurrentPID() {
        return Long.parseLong(Platform.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactory.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactory.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactory.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static void append(StringBuilder builder, String caption, Object value) {
        builder.append(caption).append(StringKit.nullToDefault(Convert.toString(value), "[n/a]")).append("\n");
    }

    public OperatingSystem getOperatingSystem() {
        return this.os.get();
    }

    private OperatingSystem createOperatingSystem() {
        switch (OS_CURRENT_PLATFORM) {
            case WINDOWS: {
                return new WindowsOperatingSystem();
            }
            case LINUX: {
                return new LinuxOperatingSystem();
            }
            case MACOSX: {
                return new MacOperatingSystem();
            }
            case SOLARIS: {
                return new SolarisOperatingSystem();
            }
            case FREEBSD: {
                return new FreeBsdOperatingSystem();
            }
            case AIX: {
                return new AixOperatingSystem();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + com.sun.jna.Platform.getOSType());
    }

    public HardwareAbstractionLayer getHardware() {
        return this.hardware.get();
    }

    private HardwareAbstractionLayer createHardware() {
        switch (OS_CURRENT_PLATFORM) {
            case WINDOWS: {
                return new WindowsHardwareAbstractionLayer();
            }
            case LINUX: {
                return new LinuxHardwareAbstractionLayer();
            }
            case MACOSX: {
                return new MacHardwareAbstractionLayer();
            }
            case SOLARIS: {
                return new SolarisHardwareAbstractionLayer();
            }
            case FREEBSD: {
                return new FreeBsdHardwareAbstractionLayer();
            }
            case AIX: {
                return new AixHardwareAbstractionLayer();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + com.sun.jna.Platform.getOSType());
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MACOSX,
        SOLARIS,
        AIX,
        FREEBSD,
        UNKNOWN;

    }
}

