/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quintet;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;

@Immutable
final class MacFirmware
extends AbstractFirmware {
    private final Supplier<Quintet<String, String, String, String, String>> manufNameDescVersRelease = Memoize.memoize(MacFirmware::queryEfi);

    MacFirmware() {
    }

    private static Quintet<String, String, String, String, String> queryEfi() {
        String manufacturer = null;
        String name = null;
        String description = null;
        String version = null;
        String releaseDate = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            IOKit.IOIterator iter = platformExpert.getChildIterator("IODeviceTree");
            if (iter != null) {
                IOKit.IORegistryEntry entry = iter.next();
                while (entry != null) {
                    switch (entry.getName()) {
                        case "rom": {
                            byte[] data = entry.getByteArrayProperty("vendor");
                            if (data != null) {
                                manufacturer = new String(data, StandardCharsets.UTF_8).trim();
                            }
                            if ((data = entry.getByteArrayProperty("version")) != null) {
                                version = new String(data, StandardCharsets.UTF_8).trim();
                            }
                            if ((data = entry.getByteArrayProperty("release-date")) == null) break;
                            releaseDate = new String(data, StandardCharsets.UTF_8).trim();
                            break;
                        }
                        case "chosen": {
                            byte[] data = entry.getByteArrayProperty("booter-name");
                            if (data == null) break;
                            name = new String(data, StandardCharsets.UTF_8).trim();
                            break;
                        }
                        case "efi": {
                            byte[] data = entry.getByteArrayProperty("firmware-abi");
                            if (data == null) break;
                            description = new String(data, StandardCharsets.UTF_8).trim();
                            break;
                        }
                    }
                    entry.release();
                    entry = iter.next();
                }
                iter.release();
            }
            platformExpert.release();
        }
        return new Quintet<String, String, String, String, String>(StringKit.isBlank(manufacturer) ? "unknown" : manufacturer, StringKit.isBlank(name) ? "unknown" : name, StringKit.isBlank(description) ? "unknown" : description, StringKit.isBlank(version) ? "unknown" : version, StringKit.isBlank(releaseDate) ? "unknown" : releaseDate);
    }

    @Override
    public String getManufacturer() {
        return this.manufNameDescVersRelease.get().getA();
    }

    @Override
    public String getName() {
        return this.manufNameDescVersRelease.get().getB();
    }

    @Override
    public String getDescription() {
        return this.manufNameDescVersRelease.get().getC();
    }

    @Override
    public String getVersion() {
        return this.manufNameDescVersRelease.get().getD();
    }

    @Override
    public String getReleaseDate() {
        return this.manufNameDescVersRelease.get().getE();
    }
}

