/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractVirtualMemory;
import org.aoju.bus.health.unix.solaris.drivers.SystemPages;
import org.aoju.bus.health.unix.solaris.hardware.SolarisGlobalMemory;

@ThreadSafe
final class SolarisVirtualMemory
extends AbstractVirtualMemory {
    private static final Pattern SWAP_INFO = Pattern.compile(".+\\s(\\d+)K\\s+(\\d+)K$");
    private final SolarisGlobalMemory global;
    private final Supplier<Pair<Long, Long>> availTotal = Memoize.memoize(SystemPages::queryAvailableTotal, Memoize.defaultExpiration());
    private final Supplier<Pair<Long, Long>> usedTotal = Memoize.memoize(SolarisVirtualMemory::querySwapInfo, Memoize.defaultExpiration());
    private final Supplier<Long> pagesIn = Memoize.memoize(SolarisVirtualMemory::queryPagesIn, Memoize.defaultExpiration());
    private final Supplier<Long> pagesOut = Memoize.memoize(SolarisVirtualMemory::queryPagesOut, Memoize.defaultExpiration());

    SolarisVirtualMemory(SolarisGlobalMemory solarisGlobalMemory) {
        this.global = solarisGlobalMemory;
    }

    private static long queryPagesIn() {
        long swapPagesIn = 0L;
        for (String s : Executor.runNative("kstat -p cpu_stat:::pgswapin")) {
            swapPagesIn += Builder.parseLastLong(s, 0L);
        }
        return swapPagesIn;
    }

    private static long queryPagesOut() {
        long swapPagesOut = 0L;
        for (String s : Executor.runNative("kstat -p cpu_stat:::pgswapout")) {
            swapPagesOut += Builder.parseLastLong(s, 0L);
        }
        return swapPagesOut;
    }

    private static Pair<Long, Long> querySwapInfo() {
        long swapTotal = 0L;
        long swapUsed = 0L;
        String swap = Executor.getAnswerAt("swap -lk", 1);
        Matcher m = SWAP_INFO.matcher(swap);
        if (m.matches()) {
            swapTotal = Builder.parseLongOrDefault(m.group(1), 0L) << 10;
            swapUsed = swapTotal - (Builder.parseLongOrDefault(m.group(2), 0L) << 10);
        }
        return Pair.of(swapUsed, swapTotal);
    }

    @Override
    public long getSwapUsed() {
        return this.usedTotal.get().getLeft();
    }

    @Override
    public long getSwapTotal() {
        return this.usedTotal.get().getRight();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getPageSize() * this.availTotal.get().getRight() + this.getSwapTotal();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getPageSize() * (this.availTotal.get().getRight() - this.availTotal.get().getLeft()) + this.getSwapUsed();
    }

    @Override
    public long getSwapPagesIn() {
        return this.pagesIn.get();
    }

    @Override
    public long getSwapPagesOut() {
        return this.pagesOut.get();
    }
}

