/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.StorageOptions;

public class TransferCapability
implements Serializable {
    private ApplicationEntity ae;
    private String commonName;
    private String sopClass;
    private Role role;
    private String[] transferSyntaxes;
    private String[] prefTransferSyntaxes = new String[0];
    private EnumSet<Option.Type> types;
    private StorageOptions storageOptions;

    public TransferCapability() {
        this(null, "1.2.840.10008.1.1", Role.SCU, "1.2.840.10008.1.2");
    }

    public TransferCapability(String commonName, String sopClass, Role role, String ... transferSyntaxes) {
        this.setCommonName(commonName);
        this.setSopClass(sopClass);
        this.setRole(role);
        this.setTransferSyntaxes(transferSyntaxes);
    }

    public void setApplicationEntity(ApplicationEntity ae) {
        if (ae != null && this.ae != null) {
            throw new IllegalStateException("already owned by AE " + this.ae.getAETitle());
        }
        this.ae = ae;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        if (role == null) {
            throw new NullPointerException();
        }
        if (this.role == role) {
            return;
        }
        ApplicationEntity ae = this.ae;
        if (ae != null) {
            ae.removeTransferCapabilityFor(this.sopClass, this.role);
        }
        this.role = role;
        if (ae != null) {
            ae.addTransferCapability(this);
        }
    }

    public String getSopClass() {
        return this.sopClass;
    }

    public void setSopClass(String sopClass) {
        if (sopClass.isEmpty()) {
            throw new IllegalArgumentException("empty sopClass");
        }
        if (sopClass.equals(this.sopClass)) {
            return;
        }
        ApplicationEntity ae = this.ae;
        if (ae != null) {
            ae.removeTransferCapabilityFor(sopClass, this.role);
        }
        this.sopClass = sopClass;
        if (ae != null) {
            ae.addTransferCapability(this);
        }
    }

    public String[] getTransferSyntaxes() {
        return this.transferSyntaxes;
    }

    public void setTransferSyntaxes(String ... transferSyntaxes) {
        this.transferSyntaxes = Property.requireContainsNoEmpty(Property.requireNotEmpty(transferSyntaxes, "missing transferSyntax"), "empty transferSyntax");
    }

    public String[] getPreferredTransferSyntaxes() {
        return this.prefTransferSyntaxes;
    }

    public void setPreferredTransferSyntaxes(String ... transferSyntaxes) {
        this.prefTransferSyntaxes = Property.requireContainsNoEmpty(transferSyntaxes, "empty transferSyntax");
    }

    public boolean containsTransferSyntax(String ts) {
        return "*".equals(this.transferSyntaxes[0]) || Property.contains(this.transferSyntaxes, ts);
    }

    public String selectTransferSyntax(String ... transferSyntaxes) {
        if (transferSyntaxes.length == 1) {
            return this.containsTransferSyntax(transferSyntaxes[0]) ? transferSyntaxes[0] : null;
        }
        List<String> acceptable = this.retainAcceptable(transferSyntaxes);
        if (acceptable.isEmpty()) {
            return null;
        }
        for (String prefTransferSyntax : this.prefTransferSyntaxes.length > 0 ? this.prefTransferSyntaxes : this.ae.getPreferredTransferSyntaxes()) {
            if (!acceptable.contains(prefTransferSyntax)) continue;
            return prefTransferSyntax;
        }
        return acceptable.get(0);
    }

    private List<String> retainAcceptable(String[] transferSyntaxes) {
        ArrayList<String> acceptable = new ArrayList<String>(transferSyntaxes.length);
        for (String transferSyntax : transferSyntaxes) {
            if (!this.containsTransferSyntax(transferSyntax)) continue;
            acceptable.add(transferSyntax);
        }
        return acceptable;
    }

    public EnumSet<Option.Type> getTypes() {
        return this.types;
    }

    public void setTypes(EnumSet<Option.Type> types) {
        this.types = types;
    }

    public StorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    public void setStorageOptions(StorageOptions storageOptions) {
        this.storageOptions = storageOptions;
    }

    public String toString() {
        return this.promptTo(new StringBuilder(512), "").toString();
    }

    public StringBuilder promptTo(StringBuilder sb, String indent) {
        String indent2 = indent + " ";
        Property.appendLine(sb, indent, "TransferCapability[cn: ", this.commonName);
        Property.appendLine(sb, new Object[]{indent2, "role: ", this.role});
        sb.append(indent2).append("as: ");
        UID.promptTo(this.sopClass, sb).append(Property.LINE_SEPARATOR);
        for (String ts : this.transferSyntaxes) {
            sb.append(indent2).append("ts: ");
            UID.promptTo(ts, sb).append(Property.LINE_SEPARATOR);
        }
        if (this.types != null) {
            sb.append(indent2).append("QueryOptions").append(this.types).append(Property.LINE_SEPARATOR);
        }
        if (this.storageOptions != null) {
            sb.append(indent2).append(this.storageOptions).append(Property.LINE_SEPARATOR);
        }
        return sb.append(indent).append(']');
    }

    public static enum Role {
        SCU,
        SCP;

    }
}

