/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class HuaweiProvider
extends AbstractProvider {
    public HuaweiProvider(Context context) {
        super(context, Registry.HUAWEI);
    }

    public HuaweiProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.HUAWEI, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("grant_type", "authorization_code");
        params.put("code", callback.getAuthorization_code());
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        params.put("redirect_uri", this.context.getRedirectUri());
        Httpx.post(this.source.accessToken(), params);
        return this.getAuthToken(params);
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nsp_ts", System.currentTimeMillis());
        params.put("access_token", accToken.getAccessToken());
        params.put("nsp_fmt", "JS");
        params.put("nsp_svc", "OpenUP.User.getInfo");
        String response = Httpx.post(this.source.userInfo(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("userID")).username(object.getString("userName")).nickname(object.getString("userName")).gender(this.getRealGender(object)).avatar(object.getString("headPictureURL")).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        params.put("refresh_token", accToken.getRefreshToken());
        params.put("grant_type", "refresh_token");
        Httpx.post(this.source.accessToken(), params);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getAuthToken(params)).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", true, HuaweiProvider.getScopes(true, OauthScope.Huawei.values()))).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("nsp_ts", System.currentTimeMillis()).queryParam("access_token", accToken.getAccessToken()).queryParam("nsp_fmt", "JS").queryParam("nsp_svc", "OpenUP.User.getInfo").build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"NSP_STATUS")) {
            throw new AuthorizedException(object.getString("error"));
        }
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("sub_error") + ":" + object.getString("error_description"));
        }
    }

    private AccToken getAuthToken(Map<String, Object> params) {
        String response = Httpx.post(this.source.accessToken(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).build();
    }
}

