/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class MeituanProvider
extends AbstractProvider {
    public MeituanProvider(Context context) {
        super(context, Registry.MEITUAN);
    }

    public MeituanProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.MEITUAN, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getAppKey());
        params.put("secret", this.context.getAppSecret());
        params.put("code", callback.getCode());
        params.put("grant_type", "authorization_code");
        String response = Httpx.post(this.source.accessToken(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getAppKey());
        params.put("secret", this.context.getAppSecret());
        params.put("access_token", accToken.getAccessToken());
        String response = Httpx.post(this.source.refresh(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("openid")).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("avatar")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getAppKey());
        params.put("secret", this.context.getAppSecret());
        params.put("refresh_token", accToken.getRefreshToken());
        params.put("grant_type", "refresh_token");
        String response = Httpx.post(this.source.refresh(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).build()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", "").build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_code")) {
            throw new AuthorizedException(object.getString("erroe_msg"));
        }
    }
}

