/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.office.support.excel.ExcelKit;
import org.aoju.bus.office.support.excel.StyleSet;
import org.aoju.bus.office.support.excel.cell.CellEditor;
import org.aoju.bus.office.support.excel.cell.CellLocation;
import org.aoju.bus.office.support.excel.cell.FormulaCellValue;
import org.aoju.bus.office.support.excel.editors.TrimEditor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;

public class CellKit {
    public static Object getCellValue(Cell cell) {
        return CellKit.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return CellKit.getCellValue(cell, cell.getCellType(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        if (null == cell) {
            return null;
        }
        return CellKit.getCellValue(cell, cell.getCellType(), cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellKit.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        if (null == cell) {
            return null;
        }
        if (null == cellType) {
            cellType = cell.getCellType();
        }
        if (CellType.BLANK == cellType) {
            cell = CellKit.getMergedRegionCell(cell);
            cellType = cell.getCellType();
        }
        switch (cellType) {
            case NUMERIC: {
                value = CellKit.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = CellKit.getCellValue(cell, cell.getCachedFormulaResultType(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                value = null == error ? "" : error.getString();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader) {
        if (null == cell) {
            return;
        }
        if (null != styleSet) {
            CellStyle headCellStyle = styleSet.getHeadCellStyle();
            CellStyle cellStyle = styleSet.getCellStyle();
            if (isHeader && null != headCellStyle) {
                cell.setCellStyle(headCellStyle);
            } else if (null != cellStyle) {
                cell.setCellStyle(cellStyle);
            }
        }
        if (value instanceof Date) {
            if (null != styleSet && null != styleSet.getCellStyleForDate()) {
                cell.setCellStyle(styleSet.getCellStyleForDate());
            }
        } else if (value instanceof TemporalAccessor) {
            if (null != styleSet && null != styleSet.getCellStyleForDate()) {
                cell.setCellStyle(styleSet.getCellStyleForDate());
            }
        } else if (value instanceof Calendar) {
            if (null != styleSet && null != styleSet.getCellStyleForDate()) {
                cell.setCellStyle(styleSet.getCellStyleForDate());
            }
        } else if (value instanceof Number && (value instanceof Double || value instanceof Float || value instanceof BigDecimal) && null != styleSet && null != styleSet.getCellStyleForNumber()) {
            cell.setCellStyle(styleSet.getCellStyleForNumber());
        }
        CellKit.setCellValue(cell, value, null);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style) {
        if (null == cell) {
            return;
        }
        if (null != style) {
            cell.setCellStyle(style);
        }
        if (null == value) {
            cell.setCellValue("");
        } else if (value instanceof FormulaCellValue) {
            cell.setCellFormula(((FormulaCellValue)value).getValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof TemporalAccessor) {
            if (value instanceof Instant) {
                cell.setCellValue(Date.from((Instant)value));
            } else if (value instanceof LocalDateTime) {
                cell.setCellValue((LocalDateTime)value);
            } else if (value instanceof LocalDate) {
                cell.setCellValue((LocalDate)value);
            }
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return CellKit.isMergedRegion(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static boolean isMergedRegion(Cell cell) {
        return CellKit.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Object getMergedRegionValue(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return CellKit.getMergedRegionValue(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static Object getMergedRegionValue(Sheet sheet, int x, int y) {
        return CellKit.getCellValue(CellKit.getMergedRegionCell(sheet, x, y));
    }

    public static Cell getMergedRegionCell(Cell cell) {
        return CellKit.getMergedRegionCell(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static Cell getMergedRegionCell(Sheet sheet, int x, int y) {
        List addrs = sheet.getMergedRegions();
        for (CellRangeAddress ca : addrs) {
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (y < firstRow || y > lastRow || x < firstColumn || x > lastColumn) continue;
            return SheetUtil.getCell((Sheet)sheet, (int)firstRow, (int)firstColumn);
        }
        return SheetUtil.getCell((Sheet)sheet, (int)y, (int)x);
    }

    private static Object getNumericValue(Cell cell) {
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null != style) {
            long longPart;
            short formatIndex = style.getDataFormat();
            if (CellKit.isDateType(cell, formatIndex)) {
                return DateKit.date(cell.getDateCellValue());
            }
            String format = style.getDataFormatString();
            if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }

    private static boolean isDateType(Cell cell, int formatIndex) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return DateUtil.isCellDateFormatted((Cell)cell);
    }
}

