/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.aoju.bus.office.support.excel.sax.AbstractExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.RowHandler;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class Excel03SaxReader
extends AbstractExcelSaxReader<Excel03SaxReader>
implements HSSFListener {
    private boolean isOutputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private boolean isOutputNextStringRecord;
    private List<Object> rowCellList = new ArrayList<Object>();
    private int rid = -1;
    private int curRid = -1;
    private RowHandler rowHandler;

    public Excel03SaxReader(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    @Override
    public Excel03SaxReader read(File file, int rid) throws InstrumentException {
        try {
            return this.read(new POIFSFileSystem(file), rid);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public Excel03SaxReader read(InputStream excelStream, int rid) throws InstrumentException {
        try {
            return this.read(new POIFSFileSystem(excelStream), rid);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public Excel03SaxReader read(POIFSFileSystem fs, int rid) throws InstrumentException {
        this.rid = rid;
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
        HSSFRequest request = new HSSFRequest();
        if (this.isOutputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        HSSFEventFactory factory = new HSSFEventFactory();
        try {
            factory.processWorkbookEvents(request, fs);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close((Closeable)fs);
        }
        return this;
    }

    public int getSheetIndex() {
        return this.rid;
    }

    public String getSheetName() {
        if (this.boundSheetRecords.size() > this.rid) {
            return this.boundSheetRecords.get(this.rid > -1 ? this.rid : this.curRid).getSheetname();
        }
        return null;
    }

    public void processRecord(Record record) {
        if (this.rid > -1 && this.curRid > this.rid) {
            return;
        }
        if (record instanceof BoundSheetRecord) {
            this.boundSheetRecords.add((BoundSheetRecord)record);
        } else if (record instanceof SSTRecord) {
            this.sstRecord = (SSTRecord)record;
        } else if (record instanceof BOFRecord) {
            BOFRecord bofRecord = (BOFRecord)record;
            if (bofRecord.getType() == 16) {
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                ++this.curRid;
            }
        } else if (record instanceof EOFRecord) {
            this.processLastCellSheet();
        } else if (this.isProcessCurrentSheet()) {
            if (record instanceof MissingCellDummyRecord) {
                MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
                this.addToRowCellList(mc);
            } else if (record instanceof LastCellOfRowDummyRecord) {
                this.processLastCell((LastCellOfRowDummyRecord)record);
            } else {
                this.processCellValue(record);
            }
        }
    }

    private void addToRowCellList(MissingCellDummyRecord record) {
        this.addToRowCellList(record.getRow(), record.getColumn(), "");
    }

    private void addToRowCellList(CellValueRecordInterface record, Object value) {
        this.addToRowCellList(record.getRow(), record.getColumn(), value);
    }

    private void addToRowCellList(int row, int column, Object value) {
        while (column > this.rowCellList.size()) {
            this.rowCellList.add("");
            this.rowHandler.handleCell(this.curRid, row, this.rowCellList.size() - 1, value, null);
        }
        this.rowCellList.add(column, value);
        this.rowHandler.handleCell(this.curRid, row, column, value, null);
    }

    private void processCellValue(Record record) {
        Object value = null;
        switch (record.getSid()) {
            case 513: {
                this.addToRowCellList((CellValueRecordInterface)((BlankRecord)record), "");
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                this.addToRowCellList((CellValueRecordInterface)berec, berec.getBooleanValue());
                break;
            }
            case 6: {
                FormulaRecord formulaRec = (FormulaRecord)record;
                if (this.isOutputFormulaValues) {
                    if (Double.isNaN(formulaRec.getValue())) {
                        this.isOutputNextStringRecord = true;
                    } else {
                        value = this.formatListener.formatNumberDateCell((CellValueRecordInterface)formulaRec);
                    }
                } else {
                    value = StringKit.wrap(HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])formulaRec.getParsedExpression()), "\"");
                }
                this.addToRowCellList((CellValueRecordInterface)formulaRec, value);
                break;
            }
            case 519: {
                if (!this.isOutputNextStringRecord) break;
                this.isOutputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                value = lrec.getValue();
                this.addToRowCellList((CellValueRecordInterface)lrec, value);
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                if (null != this.sstRecord) {
                    value = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                }
                this.addToRowCellList((CellValueRecordInterface)lsrec, ObjectKit.defaultIfNull(value, ""));
                break;
            }
            case 515: {
                double doubleValue;
                long longPart;
                NumberRecord numrec = (NumberRecord)record;
                String formatString = this.formatListener.getFormatString((CellValueRecordInterface)numrec);
                value = StringKit.contains((CharSequence)formatString, ".") ? Double.valueOf(numrec.getValue()) : (StringKit.containsAny((CharSequence)formatString, "/", ":", "\u5e74", "\u6708", "\u65e5", "\u65f6", "\u5206", "\u79d2") ? ExcelSaxKit.getDateValue(numrec.getValue()) : ((double)(longPart = (long)(doubleValue = numrec.getValue())) == doubleValue ? (Number)longPart : (Number)doubleValue));
                this.addToRowCellList((CellValueRecordInterface)numrec, value);
                break;
            }
        }
    }

    private void processLastCell(LastCellOfRowDummyRecord lastCell) {
        this.rowHandler.handle(this.curRid, lastCell.getRow(), this.rowCellList);
        this.rowCellList.clear();
    }

    private boolean isProcessCurrentSheet() {
        return this.rid < 0 || this.curRid == this.rid;
    }

    private void processLastCellSheet() {
        this.rowHandler.doAfterAllAnalysed();
    }
}

