/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import org.aoju.bus.setting.magic.AbstractElement;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.IniSection;

public class IniPropertyImpl
extends AbstractElement
implements IniProperty {
    private IniSection section;
    private String key;

    public IniPropertyImpl(IniSection section, String key, String value, String originalValue, int lineNumber) {
        super(value, originalValue, lineNumber);
        this.section = section;
        this.key = key;
    }

    public IniPropertyImpl(String key, String value, String originalValue, int lineNumber) {
        super(value, originalValue, lineNumber);
        this.key = key;
    }

    public IniPropertyImpl(IniSection section, String key, String value, int lineNumber) {
        super(value, key + '=' + value, lineNumber);
        this.section = section;
        this.key = key;
    }

    public IniPropertyImpl(String key, String value, int lineNumber) {
        super(value, key + '=' + value, lineNumber);
        this.key = key;
    }

    @Override
    public IniSection getSection() {
        return this.section;
    }

    @Override
    public void setSection(IniSection section) {
        this.section = section;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public void changeKey(String newKey) {
        this.key = newKey;
    }

    @Override
    public String setKey(String newKey) {
        String old = this.key;
        this.changeKey(newKey);
        this.setOriginalValue(this.keyChanged(newKey));
        return old;
    }

    protected String keyChanged(String newKey) {
        return this.key + '=' + newKey;
    }

    @Override
    protected String valueChanged(String newValue) {
        return this.key + '=' + newValue;
    }

    @Override
    public IniComment getComment() {
        return null;
    }

    @Override
    public String getKey() {
        return this.key();
    }
}

