/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.aoju.bus.core.clone.Support;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class DynaBean
extends Support<DynaBean>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Object bean;

    public DynaBean(Class<?> beanClass, Object ... params) {
        this(ReflectKit.newInstance(beanClass, params));
    }

    public DynaBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynaBean) {
            bean = ((DynaBean)bean).getBean();
        }
        this.bean = bean;
        this.beanClass = ClassKit.getClass(bean);
    }

    public static DynaBean create(Object bean) {
        return new DynaBean(bean);
    }

    public static DynaBean create(Class<?> beanClass, Object ... params) {
        return new DynaBean(beanClass, params);
    }

    public <T> T get(String fieldName) throws InstrumentException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        try {
            Method method = BeanKit.getBeanDesc(this.beanClass).getGetter(fieldName);
            if (null == method) {
                throw new InstrumentException("No get method for {}", fieldName);
            }
            return (T)method.invoke(this.bean, new Object[0]);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public <T> T safeGet(String fieldName) {
        try {
            return this.get(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void set(String fieldName, Object value) throws InstrumentException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
            return;
        }
        try {
            Method setter = BeanKit.getBeanDesc(this.beanClass).getSetter(fieldName);
            if (null == setter) {
                throw new InstrumentException("No set method for {}", fieldName);
            }
            setter.invoke(this.bean, value);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public Object invoke(String methodName, Object ... params) {
        return ReflectKit.invoke(this.bean, methodName, params);
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynaBean other = (DynaBean)obj;
        if (this.bean == null) {
            return other.bean == null;
        }
        return this.bean.equals(other.bean);
    }

    public String toString() {
        return this.bean.toString();
    }
}

